/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.result;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.validation.ElementKind;
import javax.validation.Path;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.shell.ParameterDescription;
import org.springframework.shell.ParameterResolver;
import org.springframework.shell.ParameterValidationException;
import org.springframework.shell.Utils;
import org.springframework.shell.result.TerminalAwareResultHandler;

public class ParameterValidationExceptionResultHandler
extends TerminalAwareResultHandler<ParameterValidationException> {
    @Autowired
    private List<ParameterResolver> parameterResolvers;

    @Override
    protected void doHandleResult(ParameterValidationException result) {
        this.terminal.writer().println(new AttributedString((CharSequence)"The following constraints were not met:", AttributedStyle.DEFAULT.foreground(1)).toAnsi());
        result.getConstraintViolations().stream().forEach(v -> {
            Optional<Integer> parameterIndex = StreamSupport.stream(v.getPropertyPath().spliterator(), false).filter(n -> n.getKind() == ElementKind.PARAMETER).map(n -> ((Path.ParameterNode)n).getParameterIndex()).findFirst();
            MethodParameter methodParameter = Utils.createMethodParameter(result.getMethodTarget().getMethod(), parameterIndex.get());
            List descriptions = this.findParameterResolver(methodParameter).describe(methodParameter).collect(Collectors.toList());
            if (descriptions.size() == 1) {
                ParameterDescription description = (ParameterDescription)descriptions.get(0);
                AttributedStringBuilder ansi = new AttributedStringBuilder(100);
                ansi.append((CharSequence)"\t").append((CharSequence)description.keys().get(0), AttributedStyle.DEFAULT.foreground(1).bold());
                ansi.append((CharSequence)" ").append((CharSequence)description.formal(), AttributedStyle.DEFAULT.foreground(1).underline());
                String msg = String.format(" : %s (You passed '%s')", v.getMessage(), String.valueOf(v.getInvalidValue()));
                ansi.append((CharSequence)msg, AttributedStyle.DEFAULT.foreground(1));
                this.terminal.writer().println(ansi.toAnsi(this.terminal));
            } else {
                this.terminal.writer().println(new AttributedString((CharSequence)v.toString(), AttributedStyle.DEFAULT.foreground(1)).toAnsi(this.terminal));
            }
        });
    }

    private ParameterResolver findParameterResolver(MethodParameter methodParameter) {
        return this.parameterResolvers.stream().filter(pr -> pr.supports(methodParameter)).findFirst().get();
    }
}

