/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.databasewriter.commands;

import com.xebialabs.xlrelease.databasewriter.service.ConfigurationService;
import com.xebialabs.xlrelease.databasewriter.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.shell.standard.ShellComponent;
import org.springframework.shell.standard.ShellMethod;
import org.springframework.shell.standard.ShellOption;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ShellComponent
@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u00015\u0011Qb\u00155fY2\u001cu.\\7b]\u0012\u001c(BA\u0002\u0005\u0003!\u0019w.\\7b]\u0012\u001c(BA\u0003\u0007\u00039!\u0017\r^1cCN,wO]5uKJT!a\u0002\u0005\u0002\u0013ad'/\u001a7fCN,'BA\u0005\u000b\u0003%AXMY5bY\u0006\u00147OC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012!B:mMRR'\"A\r\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!a\u0007\f\u0003\u000f1{wmZ5oO\"AQ\u0004\u0001BC\u0002\u0013\u0005a$\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0016\u0003}\u0001\"\u0001I\u0012\u000e\u0003\u0005R!A\t\u0003\u0002\u000fM,'O^5dK&\u0011A%\t\u0002\u000f%\u0016dW-Y:f'\u0016\u0014h/[2f\u0011!1\u0003A!A!\u0002\u0013y\u0012a\u0004:fY\u0016\f7/Z*feZL7-\u001a\u0011\t\u0011!\u0002!Q1A\u0005\u0002%\nAcY8oM&<WO]1uS>t7+\u001a:wS\u000e,W#\u0001\u0016\u0011\u0005\u0001Z\u0013B\u0001\u0017\"\u0005Q\u0019uN\u001c4jOV\u0014\u0018\r^5p]N+'O^5dK\"Aa\u0006\u0001B\u0001B\u0003%!&A\u000bd_:4\u0017nZ;sCRLwN\\*feZL7-\u001a\u0011\t\u000bA\u0002A\u0011A\u0019\u0002\rqJg.\u001b;?)\r\u0011D'\u000e\t\u0003g\u0001i\u0011A\u0001\u0005\u0006;=\u0002\ra\b\u0005\u0006Q=\u0002\rA\u000b\u0015\u0003_]\u0002\"\u0001O\"\u000e\u0003eR!AO\u001e\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002={\u00059a-Y2u_JL(B\u0001 @\u0003\u0015\u0011W-\u00198t\u0015\t\u0001\u0015)A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005\u0011\u0015aA8sO&\u0011A)\u000f\u0002\n\u0003V$xn^5sK\u0012DQA\u0012\u0001\u0005\u0002\u001d\u000bAA]3bIR\u0019\u0001j\u0013-\u0011\u0005=I\u0015B\u0001&\u0011\u0005\u0011)f.\u001b;\t\u000b1+\u0005\u0019A'\u0002\u0013I,G.Z1tK&#\u0007C\u0001(V\u001d\ty5\u000b\u0005\u0002Q!5\t\u0011K\u0003\u0002S\u0019\u00051AH]8pizJ!\u0001\u0016\t\u0002\rA\u0013X\rZ3g\u0013\t1vK\u0001\u0004TiJLgn\u001a\u0006\u0003)BAQ!W#A\u00025\u000bAAZ5mK\"\"QiW2e!\ta\u0016-D\u0001^\u0015\tqv,\u0001\u0005ti\u0006tG-\u0019:e\u0015\t\u0001w(A\u0003tQ\u0016dG.\u0003\u0002c;\nY1\u000b[3mY6+G\u000f[8e\u0003\u00151\u0018\r\\;fC\u0005)\u0017\u0001\f*fC\u0012\u001c\b\u0005\u001e5fAI,G.Z1tK\u0002\u001awN\u001c;f]R\u0004\u0013M\u001c3!gR|'/Z:!S:\u0004c-\u001b7f\u0011\u00159\u0007\u0001\"\u0001i\u0003\u00159(/\u001b;f)\rA\u0015N\u001b\u0005\u0006\u0019\u001a\u0004\r!\u0014\u0005\u00063\u001a\u0004\r!\u0014\u0015\u0005Mn\u001bG.I\u0001n\u0003\u0015\u001aFo\u001c:fAQDW\r\t:fY\u0016\f7/\u001a\u0011d_:$XM\u001c;!S:\u0004C-\u0019;bE\u0006\u001cX\rC\u0003p\u0001\u0011\u0005\u0001/A\u0005b]>t\u00170\\5{KR)\u0001*]?\u0002\n!)!O\u001ca\u0001\u001b\u00061An\\2bY\u0016Dc!\u001d;xqj\\\bC\u0001/v\u0013\t1XLA\u0006TQ\u0016dGn\u00149uS>t\u0017\u0001\u00025fYB\f\u0013!_\u00017\u0019>\u001c\u0017\r\\3!i>\u0004#-\u001a\u0011vg\u0016$\u0007EZ8sA\u0005twN\\=nSj\fG/[8oY\u0001*gf\u001a\u0018!EU\u001b&\u0005I8sA\trEJI\u0001\rI\u00164\u0017-\u001e7u-\u0006dW/Z\u0011\u0002y\u0006Aql\u0018(P\u001d\u0016{v\fC\u0003\u007f]\u0002\u0007Q*\u0001\u000ebI\u0012LG/[8oC2\u0014V\r\u001d7bG\u0016lWM\u001c;t!\u0006$\b\u000e\u000b\u0005~i^\f\tA_A\u0003C\t\t\u0019!AA4\u0003\u0002\u0002\u0018\r\u001e5!i>\u0004\u0013\r\t4jY\u0016\u0004s/\u001b;iA\u0005$G-\u001b;j_:\fG\u000eI:ue&twm\u001d\u0011uQ\u0006$\b%\\;ti\u0002\u0012W\r\t:fa2\f7-\u001a3!o&$\b\u000e\t9mC\u000e,\u0007n\u001c7eKJ\u001c\be\u001e5f]\u0002\ngn\u001c8z[&T\u0018N\\4-AM,8\r\u001b\u0011bg\u0002z'oZ1oSj\fG/[8og\u0002r\u0017-\\3t]\u0001ze.\u001a\u0011tiJLgn\u001a\u0011qKJ\u0004C.\u001b8fY\u0001\u0012X\r\u001d7bG\u0016lWM\u001c;!SN\u00043-Y:fAM,gn]5uSZ,g&\t\u0002\u0002\b\u0005Aql\u0018(V\u00192{v\f\u0003\u0004\u0002\f9\u0004\r!T\u0001\u0018C:|g._7ju\u0006$\u0018n\u001c8PkR\u0004X\u000f\u001e)bi\"D\u0013\"!\u0003uo\u0006=!0!\u0002\"\u0005\u0005E\u0011a[%gAM\u0004XmY5gS\u0016$\u0007%\u0019\u0011nCB\u0004\u0018N\\4!_\u001a\u0004\u0013\r\u001c7!e\u0016\u0004H.Y2f[\u0016tGo\u001d\u0011nC\u0012,\u0007\u0005Z;sS:<\u0007%\u00198p]fl\u0017N_1uS>t\u0007e^5mY\u0002\u0012W\rI<sSR$XM\u001c\u0011u_\u0002\"\b.\u001a\u0011ta\u0016\u001c\u0017NZ5fI\u00022\u0017\u000e\\3/Q\u0015q7lYA\u000bC\t\t9\"A>Ue&,7\u000f\t;pA\u0005twN\\=nSj,\u0007E]3mK\u0006\u001cXm]\u0018wCJL\u0017M\u00197fg>*Go\u0019\u0011cs\u0002\u0012X-\\8wS:<\u0007\u0005]1tg^|'\u000fZ:!C:$\u0007%\\1tW&tw\rI3nC&d7\u000f\f\u0011qQ>tW\r\t8v[\n,'o\u001d\u0017!kN,'O\\1nKN\u0004\u0013M\u001c3!MVdG\u000e\t8b[\u0016\u001c\bbBA\u000e\u0001\u0011\u0005\u0011QD\u0001\u0012e\u0016\fGmX1mY~\u000b'o\u00195jm\u0016$G#\u0004%\u0002 \u0005%\u0012qGA\u001e\u0003\u007f\t\u0019\u0005C\u0004\u0002\"\u0005e\u0001\u0019A'\u0002\tA\fG\u000f\u001b\u0015\u0007\u0003?!x/!\n\"\u0005\u0005\u001d\u0012\u0001\u000e#je\u0016\u001cGo\u001c:zAQ|\u0007e\u001e5jG\"\u0004C\u000f[3!\u0015N{e\n\t4jY\u0016\u001c\be^5mY\u0002\u0012W\r\t3po:dw.\u00193fI\"9q.!\u0007A\u0002\u0005-\u0002cA\b\u0002.%\u0019\u0011q\u0006\t\u0003\u000f\t{w\u000e\\3b]\"2\u0011\u0011\u0006;x\u0003g\t#!!\u000e\u0002\u0003sJe\rI:qK\u000eLg-[3eAQDW\r\t3bi\u0006\u0004s/\u001b7mA\t,\u0007%\u00198p]fl\u0017N_3eu\u0001*W.Y5mg2\u0002\u0003\u000f[8oK\u0002rW/\u001c2feNd\u0003%^:fe:\fW.Z:!C:$\u0007\u0005K5gA\u00054\u0018-\u001b7bE2,\u0017\u0006\t4vY2\u0004c.Y7fg\u0002:\u0018\u000e\u001c7!E\u0016\u0004#/\u001a9mC\u000e,G\rI5oAQDW\r\t:fY\u0016\f7/Z:(A\r|g\u000e^3oiNt\u0003ET8uK\u0002\"\b.\u0019;!C:|g._7ju\u0006$\u0018n\u001c8!G\u0006t\u0007\u0005^1lK\u0002Bw.\u001e:t]!1!/!\u0007A\u00025C\u0003\"a\u000euobT\u0018Q\u0001\u0005\u0007}\u0006e\u0001\u0019A')\u0013\u0005mBo^A\u0001u\u0006\u0015\u0001bBA\u0006\u00033\u0001\r!\u0014\u0015\n\u0003\u007f!x/a\u0004{\u0003\u000bA\u0001\"!\u0012\u0002\u001a\u0001\u0007\u00111F\u0001\rg.L\u0007/\u0012=jgRLgn\u001a\u0015\u0007\u0003\u0007\"x/!\u0013\"\u0005\u0005-\u0013AO*lSB\u0004#/\u001a7fCN,7\u000f\t;iCR\u0004s/\u001a:fA\u0005d'/Z1es\u0002\ngn\u001c8z[&TX\r\u001a\u0011b]\u0012\u0004Cm\\<oY>\fG-\u001a3/Q\u0019\tIbW2\u0002P\u0005\u0012\u0011\u0011K\u0001\u0002>I+\u0017\rZ:!C2d\u0007%\u0019:dQ&4X\r\u001a\u0011sK2,\u0017m]3tA%tGo\u001c\u0011ta\u0016\u001c\u0017NZ5fI\u0002\"\u0017N]3di>\u0014\u0018\u0010\f\u0011xSRD\u0007e\u001c9uS>t\u0017\r\u001c\u0011b]>t\u00170\\5{CRLwN\u001c\u0018!%\u0016dW-Y:fA\u0019LG.\u001a\u0011oC6,7\u000fI1sK\u0002ZFH]3mK\u0006\u001cXmX5e}9R7o\u001c8^A\u0005tG\r\t4pY2|w\u000f\t;iK\u00022w\u000e\u001c3fe\u0002\u001aHO];diV\u0014XM\f\u0015\u0004\u0001\u0005U\u0003c\u0001/\u0002X%\u0019\u0011\u0011L/\u0003\u001dMCW\r\u001c7D_6\u0004xN\\3oi\u0002")
public class ShellCommands
implements Logging {
    private final ReleaseService releaseService;
    private final ConfigurationService configurationService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ShellCommands shellCommands = this;
        synchronized (shellCommands) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public ConfigurationService configurationService() {
        return this.configurationService;
    }

    @ShellMethod(value="Reads the release content and stores in file")
    public void read(String releaseId, String file) {
        this.releaseService().readRelease(releaseId, file);
    }

    @ShellMethod(value="Store the release content in database")
    public void write(String releaseId, String file) {
        this.releaseService().writeRelease(releaseId, file);
    }

    @ShellMethod(value="Tries to anonymize releases/variables/etc by removing passwords and masking emails, phone numbers, usernames and full names")
    public void anonymize(@ShellOption(help="Locale to be used for anonymization, e.g. \"US\" or \"NL\"", defaultValue="__NONE__") String locale, @ShellOption(help="A path to a file with additional strings that must be replaced with placeholders when anonymizing, such as organizations names. One string per line, replacement is case sensitive.", defaultValue="__NULL__") String additionalReplacementsPath, @ShellOption(help="If specified a mapping of all replacements made during anonymization will be written to the specified file.", defaultValue="__NULL__") String anonymizationOutputPath) {
        this.configurationService().restoreDefaultAdmin();
        this.releaseService().anonReleases(locale, additionalReplacementsPath, anonymizationOutputPath);
        this.configurationService().anonConfigurations(locale, additionalReplacementsPath, anonymizationOutputPath);
    }

    @ShellMethod(value="Reads all archived releases into specified directory, with optional anonymization. Release file names are [<release_id>.json] and follow the folder structure.")
    public void read_all_archived(@ShellOption(help="Directory to which the JSON files will be downloaded") String path, @ShellOption(help="If specified the data will be anonymized: emails, phone numbers, usernames and (if available) full names will be replaced in the releases' contents. Note that anonymization can take hours.") boolean anonymize, @ShellOption(help="Locale to be used for anonymization, e.g. \"US\" or \"NL\"", defaultValue="__NULL__") String locale, @ShellOption(help="A path to a file with additional strings that must be replaced with placeholders when anonymizing, such as organizations names. One string per line, replacement is case sensitive.", defaultValue="__NULL__") String additionalReplacementsPath, @ShellOption(help="If specified a mapping of all replacements made during anonymization will be written to the specified file.", defaultValue="__NULL__") String anonymizationOutputPath, @ShellOption(help="Skip releases that were already anonymized and downloaded.") boolean skipExisting) {
        if (anonymize && locale == null) {
            this.logger().error((Function0 & java.io.Serializable & Serializable)() -> "[--locale] must be specified if anonymization was requested");
            return;
        }
        this.releaseService().readAllArchived(path, anonymize, locale, additionalReplacementsPath, anonymizationOutputPath, skipExisting);
    }

    @Autowired
    public ShellCommands(ReleaseService releaseService, ConfigurationService configurationService) {
        this.releaseService = releaseService;
        this.configurationService = configurationService;
        Logging.$init$((Logging)this);
    }
}

