class DurationPicker {
    constructor(selector) {
        this.selector = selector;
    }

    setDuration({days, hours, minutes}) {
        this.openDurationToolTip();
        let lastInputSelector = "";
        if (days) {
            let daysSelector = ".duration-picker .days";
            this.clearInput(daysSelector);
            element(By.$(daysSelector)).sendKeys(days);
            lastInputSelector = daysSelector;
        }
        if (hours) {
            let hoursSelector = ".duration-picker .hours";
            this.clearInput(hoursSelector);
            element(By.$(hoursSelector)).sendKeys(hours);
            lastInputSelector = hoursSelector;
        }
        if (minutes) {
            let minuteSelector = ".duration-picker .minutes";
            this.clearInput(minuteSelector);
            element(By.$(minuteSelector)).sendKeys(minutes);
            lastInputSelector = minuteSelector;
        }

        return this.closeDurationPicker(lastInputSelector);
    }

    clearInput(selector) {
        return element(By.$(selector)).clear();
    }

    closeDurationPicker(lastInputSelector) {
        return element(By.$(lastInputSelector)).sendKeys(protractor.Key.ENTER);
    }

    openDurationToolTip() {
        return element(By.$(`${this.selector} .duration`)).click();
    }

    removeDuration() {
        return element(By.$(`${this.selector} .remove-duration`)).click();
    }

    expectDurationToBe(expectedDuration) {
        expect(element(By.$(`${this.selector}`)).getText()).toContain(expectedDuration);
    }

    expectNoDuration() {
        expect(element(By.$(`${this.selector}`)).getText()).toContain('');
    }
}

global.DurationPicker = DurationPicker;
