import path from "path";

class ImportTemplateDialog {
    expectFileSelectorDisplayed() {
        expect(browser.isElementPresent(By.$("#importTemplateModal input[type='file']"))).toBe(true);
        return this;
    }

    expectImportButtonDisabled() {
        expect(browser.isElementPresent(By.$("#importTemplateModal .import:disabled"))).toBe(true);
        return this;
    }

    uploadFile(localPath) {
        let fullPath = path.resolve(localPath);
        let remote = require('selenium-webdriver/remote');
        browser.setFileDetector(new remote.FileDetector());
        browser.findElement(By.$("#importTemplateModal input[type='file']")).sendKeys(fullPath);
        element(By.css('#importTemplateModal button.import')).click();
        return this;
    }

    expectFileUploaded() {
        Browser.waitFor("#importTemplateModal .results:contains('Template successfully imported'):visible");
        return this;
    }

    expectFileUploadedWithWarning() {
        Browser.waitFor(".modal-body:contains('Teams in this template have been removed. They will be inherited from the folder'):visible");
        return this;
    }


    expectFileUploadRejected() {
        Browser.waitFor("#importTemplateModal .error:contains('Task use is not granted to you for types'):visible");
        return this;
    }

    close() {
        element(By.css('.modal button.close')).click();
        return this;
    }

    uploadAndCheckExpectations(templatePath, afterUploadExpectation) {
        return this.expectFileSelectorDisplayed()
            .expectImportButtonDisabled()
            .uploadFile(templatePath)[afterUploadExpectation]()
            .close();
    }
}

global.ImportTemplateDialog = ImportTemplateDialog;
