class TagEditor {
    constructor(path) {
        this.path = path;
        Browser.waitFor(this.path);
        this.editor = element(By.$(this.path));
    }

    addTag(tagName) {
        this.editor.element(By.css(".tag-input")).sendKeys(tagName);
        this.editor.element(By.css(".tag-input")).sendKeys(protractor.Key.ENTER);
        return this;
    }

    removeTag(tagName) {
        const selector = `${this.path} li:contains('${tagName}') .tag-close`;
        element(By.$(selector)).click();
        expect(browser.isElementPresent(element(By.$(selector)))).toBe(false);
        return this;
    }

    expectTaggedWith(tagName) {
        Browser.waitFor(`${this.path} li:contains('${tagName}')`);
        return this;
    }
}

global.TagEditor = TagEditor;
