// TODO: [REL-5759] change <span> to <a href="javascript:void(0)"> after getting rid of karma e2e
class ReleasesListPage {
    constructor() {
        Browser.waitFor('#releases-content');
        browser.sleep(200);
    }

    clearStatusFilter() {
        element(By.css('.ci-filter-status')).click();
        element(By.$(`.ci-filter-status .xl-react-link:contains('Clear all')`)).click();
        return this;
    }

    toggleSearch() {
        element(By.css('.toggle-search-filter')).click();
        return this;
    }

    searchBy(criteria) {
        element(By.css('.searchFilter')).clear();
        element(By.css('.searchFilter')).sendKeys(criteria);
        browser.sleep(1000);
        return this;
    }

    clickOnStatusFilter(criteria) {
        element(By.css('.ci-filter-status')).click();
        element(By.$('.ci-filter-status .react-tagsinput-input')).sendKeys(criteria);
        browser.sleep(500);
        element(By.$(`.ci-filter-status .xl-react-autocomplete-suggestion div[title='${criteria}']`)).click();
        element(By.$('.filter-title:contains(Status)')).click();
        browser.sleep(500);
        return this;
    }

    releaseElement(releaseName) {
        Browser.waitFor(`.release:contains('${releaseName}')`);
        return element(By.$(`.release:contains('${releaseName}')`));
    }

    openReleaseByName(releaseName) {
        browser.sleep(500);
        Browser.waitForDisplayed(`.release-title:contains('${releaseName}')`);
        Browser.waitForDisplayed(`.release-line .row-wrapper:contains('${releaseName}') a`);
        element(By.$(`.release-line .row-wrapper:contains('${releaseName}') a`)).click();
        return new ReleasePage();
    }

    expectReleaseAborted(title) {
        Browser.waitForDisplayed(`.release:contains('${title}')`);
        expect(element(By.$(`.release:contains('${title}')`)).isPresent()).toBe(true);
        return this;
    }

    expectReleaseStarted(title) {
        return this.expectReleaseStatus(title, 'In progress');
    }

    expectReleasePlanned(title) {
        return this.expectReleaseStatus(title, 'Planned');
    }

    expectReleaseArchived(title) {
        return this.expectReleaseStatus(title, 'Archived');
    }

    expectReleaseCompleted(title) {
        return this.expectReleaseStatus(title, 'Completed');
    }

    expectReleaseFailed(title) {
        return this.expectReleaseStatus(title, 'Failed');
    }

    expectReleaseStatus(title, status) {
        Browser.waitFor(`.release:contains('${title}')`);
        expect(element(By.$(`.release:contains('${title}') .release-status:contains('${status}')`)).isPresent()).toBe(true);
        return this;
    }

    expectNumberOfReleases(title, expectedCount) {
        const releaseSelector = `.release:contains('${title}')`;
        if (expectedCount === 1) {
            expect(element(By.$(releaseSelector)).isPresent());
        } else {
            expect(element.all(By.$(releaseSelector)).count()).toBe(expectedCount);
        }
        return this;
    }

}

global.ReleasesListPage = ReleasesListPage;
