class Dates {

    static getFormattedDate(format, date) {
        if (Array.isArray(date)) {
            date = new Date(date);
        }
        return browser.executeScript(function () {
                date = arguments[0];
                format = arguments[1];
                let $injector = angular.element('body').injector();
                let dateFilter = $injector.get('dateFilter');
                return dateFilter(date, format);
            }
            , date, format);
    }

    static expectContainingDate(inputLocator, format, date) {
        return this.getFormattedDate(format, date).then(formattedDate => {
                expect(element(inputLocator).getText()).toContain(formattedDate);
            }
        );
    }

    static expectInputContainingDate(inputLocator, format, date) {
        let elm = element(inputLocator);
        expect(elm).toBeDisplayed();
        let attribute = elm.getAttribute('value');
        return this.getFormattedDate(format, date).then(formattedDate => {
            expect(attribute).toContain(formattedDate);
        });
    }

    static expectValueContainingDate(inputLocator, format, arrayOfDate) {
        this.getFormattedDate(format, arrayOfDate).then(formattedDate => {
                expect(element(inputLocator).getAttribute('value')).toContain(formattedDate);
            }
        );
    }
}

global.Dates = Dates;
