class ProfilePage {
    constructor() {
        Browser.waitFor('#profileForm');
    }

    expectEmailDefined(email) {
        expect(element(by.model('$ctrl.profile.email')).getAttribute('value')).toBe(email);
        return this;
    }

    expectFullNameDefined(fullName) {
        expect(element(by.model('$ctrl.profile.fullName')).getAttribute('value')).toBe(fullName);
        return this;
    }

    expectNoEmailDefined() {
        this.expectEmailDefined('');
        return this;
    }

    expectNoFullNameDefined() {
        this.expectFullNameDefined('');
        return this;
    }

    expectPasswordNotToBe(password) {
        expect(element(by.css('input[data-test="password-input"]')).getAttribute('value')).not.toBe(password);
    }

    expectDateFormatToBe(dateFormat) {
        expect(element(by.model('$ctrl.profile.dateFormat')).getAttribute('value')).toBe(dateFormat);
        return this;
    }

    expectTimeFormatToBe(timeFormat) {
        expect(element(by.model('$ctrl.profile.timeFormat')).getAttribute('value')).toBe(timeFormat);
        return this;
    }

    expectFirstDayOfWeekToBe(firstDayOfWeek) {
        expect(element(by.model('$ctrl.profile.firstDayOfWeek')).getAttribute('value')).toBe(firstDayOfWeek);
        return this;
    }

    save() {
        element(By.$('#profile .save:enabled')).click();
        Browser.waitFor('.last-saved');
        return this;
    }

    setEmail(email) {
        element(by.model('$ctrl.profile.email')).sendKeys(email);
        return this.save();
    }

    setFullName(fullName) {
        element(by.model('$ctrl.profile.fullName')).sendKeys(fullName);
        return this.save();
    }

    setPassword(previousPassword, password) {
        element(by.model('$ctrl.profile.previousPassword')).sendKeys(previousPassword);
        element(by.css('input[data-test="password-input"]')).sendKeys(password);
        element(by.model('$ctrl.profile.passwordConfirmation')).sendKeys(password);
        return this.save();
    }

    setDateFormat(dateFormat) {
        element(by.css(`option[value="${dateFormat}"]`)).click();
        return this.save();
    }

    setTimeFormat(timeFormat) {
        element(by.css(`option[value="${timeFormat}"]`)).click();
        return this.save();
    }

    setFirstDayOfWeek(firstDayOfWeek) {
        element(by.css(`option[value="${firstDayOfWeek}"]`)).click();
        return this.save();
    }

    refresh() {
        Browser.softReload();
        return new ProfilePage();
    }
}

global.ProfilePage = ProfilePage;
