class PropertiesPage {
    setScheduledStartDate(date) {
        let dateTimePicker = new DateTimePicker('.scheduled-start-date .date-editor');
        dateTimePicker.setDateTime(date);
        return this;
    }

    setDueDate(date) {
        let dateTimePicker = new DateTimePicker('.due-date .date-editor');
        dateTimePicker.setDateTime(date);
        return this;
    }

    setDuration(duration) {
        let dateTimePicker = new DurationPicker('[duration-editor]');
        dateTimePicker.setDuration(duration);
        return this;
    }

    expectScheduledStartDateToBe(dateFomat, timeFormat, date) {
        let dateTimePicker = new DateTimePicker('.scheduled-start-date .date-editor');
        dateTimePicker.expectDateToBe(dateFomat, date);
        dateTimePicker.expectTimeToBe(timeFormat, date);
        return this;
    }

    expectDueDateToBe(dateFomat, timeFormat, date) {
        let dateTimePicker = new DateTimePicker('.due-date .date-editor');
        dateTimePicker.expectDateToBe(dateFomat, date);
        dateTimePicker.expectTimeToBe(timeFormat, date);
        return this;
    }

    expectDurationToBe(duration) {
        let durationPicker = new DurationPicker('[duration-editor]');
        durationPicker.expectDurationToBe(duration);
        return this;
    }

    setScriptUsername(username) {
        new InlineEditor('.script-username').set(username);
        return this;
    }

    setScriptUserPassword(password) {
        new InlineEditor('span[name="scriptUserPassword"]').set(password);
        return this;
    }

    expectScriptUsernameToBe(username) {
        expect(element(By.$('.script-username')).getText()).toContain(username);
        return this;
    }

    expectScriptUserPasswordToBe(password) {
        expect(element(By.$('span[name="scriptUserPassword"]')).getText()).toContain(password);
        return this;
    }

    save() {
        element(By.css('.continue')).click();
        return this;
    }
}

class ReleasePropertiesPage extends PropertiesPage {
    constructor() {
        super();
        Browser.waitFor('#release-properties');
    }

    selectTemplate(template) {
        element(By.css('.template-select input'))
            .getAttribute('value')
            .then((value) => {
                if (value) {
                    element(By.css('.template-select .close-icon')).click();
                }
                if (template !== 'No template') {
                    element(By.css('.template-select input')).sendKeys(template);
                    Browser.waitFor(`.template-select .yt-option[title=\'${template}\']`);
                    element(By.cssContainingText('.template-select .yt-option', template)).click();
                }
            });
        return this;
    }

    setName(name) {
        element(By.id('release-form-title')).sendKeys(name);
        return this;
    }

    setDescription(description) {
        new TextareaInlineEditor('.release-description').set(description);
        return this;
    }

    expectTemplateTitleToBe(title) {
        expect($('a[data-test="created-from-template"]').getText()).toBe(title);
        return this;
    }

    expectRiskProfileTitleToBe(title) {
        expect($('a[data-test="release-risk-profile"]').getText()).toBe(title);
        return this;
    }

    expectTemplateURLToBe(url) {
        expect($('a[data-test="created-from-template"]').getAttribute('ng-href')).toBe(url);
        return this;
    }

    expectParentReleaseTitleToBe(title) {
        expect(element(By.css('.started-from-release')).getText()).toBe(title);
        return this;
    }

    expectParentReleaseURLToBe(url) {
        expect(element(By.css('.started-from-release')).getAttribute('ng-href')).toBe(url);
        return this;
    }

    expectDescriptionToContain(description) {
        expect(element(By.css('.release-description.markdown')).getText()).toContain(description);
        return this;
    }

    scrollToVariables() {
        Browser.scrollTo(By.css('.variables'));
        return this;
    }

    focusVariable(variable) {
        new InlineEditor(`#release-properties div[inline-text-editor][name='${variable}']`).focus();
        return this;
    }

    setPasswordVariable(variable, value) {
        let editor = new InlineEditor(`#release-properties div[inline-password-editor][name='${variable}'] `);
        editor.set(value);
        return this;
    }

    setVariable(variable, value) {
        let editor = new InlineEditor(`#release-properties div[inline-text-editor][name='${variable}']`);
        editor.set(value);
        return this;
    }

    togglePublicLink() {
        element(By.css('#releaseForm-calendarPublished')).click();
        return this;
    }

    getAttachmentsList() {
        return new AttachmentsList('#release-properties .attachments-list');
    }

    checkAbortOnFailure() {
        element(By.css('#release-form-abort-on-failure')).click();
        return this;
    }

    checkAllowPasswordsInAllFields() {
        element(By.css('#release-form-allow-passwords-in-all-fields')).click();
        return this;
    }

    checkDisableNotifications() {
        element(By.css('#release-form-disable-notifications')).click();
        return this;
    }

    reload() {
        Browser.softReload();
        return this;
    }

    expectVariableDisplayed(variable, present) {
        expect(element(By.$(`#release-properties .form-group:contains('${variable}')`))).toBePresent(present);
        return this;
    }

    expectVariablesCountToBe(variablesCount) {
        expect(element.all(By.css('div[inline-text-editor]')).count()).toEqual(variablesCount);
        return this;
    }

    expectContainingVariable(variable, value) {
        let editor = new InlineEditor(`#release-properties .form-group:contains('${variable}') div[inline-text-editor]`);
        expect(editor.value()).toBe(value);
        return this;
    }

    expectTagsDisplayed(tags, present) {
        tags.forEach((tag) => expect(element(By.$(`#release-properties .form-group:contains(${tag})`))).toBePresent(present));
        return this;
    }
}

class TemplatePropertiesPage extends PropertiesPage {
    constructor() {
        super();
        Browser.waitFor('#template-properties');
    }

    setName(name) {
        element(By.css('#release-form-title')).sendKeys(name);
        return this;
    }

    setDescription(description) {
        new TextareaInlineEditor('.release-description').set(description);
        return this;
    }

    getAttachmentsList() {
        return new AttachmentsList('#template-properties .attachments-list');
    }

    removeDueDate() {
        element(By.$('.due-date .close-icon')).click();
        return this;
    }
}

global.TemplatePropertiesPage = TemplatePropertiesPage;
global.ReleasePropertiesPage = ReleasePropertiesPage;
