class BreadcrumbPage {
    static isPresent() {
        expect(element(By.$('.bread-crumbs'))).toBePresent(true);
    }

    static breadContains(index, bread) {
        expect(element(By.$(`.bread-crumbs ol li:nth-child(${index}) a`)).getText()).toContain(bread);
    }

    static breadNotContains(index) {
        expect(element(By.$(`.bread-crumbs ol li:nth-child(${index}) a`))).toBePresent(false);
    }

    static lastBreadContains(bread) {
        expect(element(By.$('.bread-crumbs ol li:last-child span')).getText()).toContain(bread);
    }

    static navigateToBreadcrumb(index) {
        return element(By.$(`.bread-crumbs ol li:nth-child(${index}) a`)).click();
    }
}

global.BreadcrumbPage = BreadcrumbPage;
