// TODO: [REL-5759] change <span> to <a href="javascript:void(0)"> after getting rid of karma e2e
class TasksListPage {
    constructor() {
        Browser.waitFor('#tasks');
    }

    openTaskDetails(title, buildResult) {
        element(By.$(`.task:contains('${title}') .task-line`)).click();
        return buildResult();
    }

    openCustomScriptDetails(title) {
        return this.openTaskDetails(title, () => new CustomScriptDetails());
    }

    openManualTaskDetails(title) {
        return this.openTaskDetails(title, () => new TaskDetails());
    }

    clickOnFilter(criteria) {
        element(By.$('.dropdown-button:contains("Filter options")')).click();
        element(By.$(`#filter-container label:contains('${criteria}')`)).click();
        element(By.$('.dropdown-button:contains("Filter options")')).click();
        return this;
    }

    setSearchFilter(filterText) {
        return element(By.css('#searchFilter')).sendKeys(filterText);
    }

    expectDateFilters(filters) {
        DateFilters.expectDateFilters(filters);
        return this;
    }

    expectTaskCountForRelease(releaseTitle, expectedCount) {
        const actualCount = element.all(By.$(`#tasks-content div:contains('${releaseTitle}') .task`)).count();
        expect(actualCount).toBe(expectedCount);
        return this;
    }

    expectTextFilter(text) {
        expect(element(By.css('filters.filter')).getText()).toBe(text);
        return this;
    }

    setOrderBy(orderBy) {
        element(By.css('.order-selector .btn:first-child')).click();
        element(By.$(`.order-selector .bootstrap-link:contains('${orderBy}')`)).click();
        element(By.css('.order-selector .btn:first-child')).click();
        browser.sleep(500);
        return this;
    }

    // Pass in expected tasks per release which should be visible on position x...:
    // [
    //   {
    //      releaseTitle: "My first release",
    //      title: "My first task",
    //      position: 0,
    //   },
    //   {
    //      releaseTitle: "My first release",
    //      title: "My third task",
    //      position: 1, // second position because of ordering by due date
    //   }
    // ]
    expectTasksDisplayedInOrder(expectedTasks) {
        expectedTasks.forEach((elm) => {
            // expectations
            const expectedTaskTitle = elm.taskTitle;
            const position = elm.taskPosition;
            const releaseTitle = elm.releaseTitle;

            const taskElement = element.all(By.css(`[data-release-title='${releaseTitle}'] .row .task`)).get(position);
            expect(taskElement).toBePresent();
            const taskTitle = taskElement.getAttribute('data-task-title');

            expect(taskTitle).toEqual(
                expectedTaskTitle,
                `Expected to find task with title ${expectedTaskTitle} but found a different title on position ${position}`,
            );
        });
    }

    expectBooleanFilters(filters) {
        element(By.css('.dropdown-button')).click();
        Object.keys(filters).forEach((key) => {
            const expectedValue = filters[key];
            expect(element.all(By.css(`[ng-model='filters.${key}']`)).count()).toBe(1);
            expect(element.all(By.css(`[ng-model='filters.${key}']:checked`)).count()).toBe(0 + expectedValue);
        });
        element(By.css('.dropdown-button')).click();
        return this;
    }

    expectTasksDisplayed(tasks) {
        Object.keys(tasks).forEach((title) => {
            const expected = tasks[title];
            const expectedCount = 0 + !!expected;
            const tasksWithTitle = element.all(By.$(`.task:contains('${title}'):visible`)).count();
            tasksWithTitle.then((result) => {
                expect(result).toBe(expectedCount, `Expected ${title} to have ${expectedCount} elements visible, but found ${result}`);
            });

            if (expected.assignedTo) {
                const assignedToTasksAmount = element
                    .all(By.$(`.task:contains('${title}') span.assignee span:contains('Assigned to'):visible span:contains('${expected.assignedTo}'):visible`))
                    .count();
                expect(assignedToTasksAmount).toBe(1, `Expected ${title} to be assigned`);
            }

            if (expected.flaggedWith) {
                const flaggedWithTasksAmount = element.all(By.$(`.task:contains('${title}') span.flags span.flag-none-icon.${expected.flaggedWith}`)).count();
                expect(flaggedWithTasksAmount).toBe(1, `Expected ${title} to be flagged`);
            }

            if (expected.unflagged) {
                const unflaggedTasksAmount = element.all(By.$(`.task:contains('${title}') span.flags:visible span.flag-none-icon`)).count();
                expect(unflaggedTasksAmount).toBe(0, `Expected ${title} not to be flagged`);
            }
        });
    }
}

global.TasksListPage = TasksListPage;
