class AttachmentsList {
    constructor(selector) {
        this.selector = selector;
    }

    uploadFile(filePath) {
        let remote = require('selenium-webdriver/remote');
        browser.setFileDetector(new remote.FileDetector());
        return browser.findElement(By.$(`${this.selector} input`)).sendKeys(filePath);
    }

    expectWithAttachment(fileName) {
        // Wait for attachment to appear
        return Browser.waitFor(`${this.selector} .filename:contains('${fileName}')`);
    }

    deleteAttachment(fileName) {
        let deleteButton = `${this.selector} tr:contains('${fileName}') .delete`;
        let confirmDeleteButton = `${this.selector} tr:contains('${fileName}') .confirmDelete`;

        Browser.waitFor(deleteButton);
        element(By.$(deleteButton)).click();
        Browser.waitFor(confirmDeleteButton);
        return element(By.$(confirmDeleteButton)).click();
    }

    expectWithNoAttachment(fileName) {
        expect(element(By.$(`${this.selector} filename:contains('${fileName}')`)).isPresent()).toBe(false);
    }

    downloadFile(fileName) {
        return element(By.$(`${this.selector} .filename:contains('${fileName}') .filelink`)).click();
    }
}

global.AttachmentsList = AttachmentsList;
