/**
 * Handles a third party login page
 * https://dev-287855.oktapreview.com/login/login.htm
 */
class OktaPage {
    // Sometimes it requires some extra time to handle SSO stuff.
    static PAGE_SLEEP = 2000;

    static expectLoginForm() {
        Browser.waitForDisplayed(`#signin-container`);
        browser.driver.findElements(by.id('signin-container')).then((elems) => expect(elems.length).toBe(1));
        return this;
    }

    static login() {
        browser.driver.findElement(by.id('okta-signin-username')).sendKeys('xl-developers@xebialabs.com');
        browser.driver.findElement(by.id('okta-signin-password')).sendKeys('0x7S9P65Z65INDCe');
        browser.driver.findElement(by.id('okta-signin-submit')).click();
        // to provide running browser redirects with some time to finish.
        browser.sleep(OktaPage.PAGE_SLEEP);
    }
}

global.OktaPage = OktaPage;
