class ReleaseGanttPage {
    constructor() {
        Browser.waitFor('#gantt');
    }

    open(title) {
        element(By.$(`.gantt_cell:contains('${title}') .gantt_open`)).click();
        return this;
    }

    openReleaseFlowAndWaitForGantt() {
        element(By.css('#release-header .subpage-links button')).click();
        element(By.$("#subpages-container div:contains('Release flow')")).click();
        return new ReleaseGanttPage();
    }

    getLeftPanel() {
        return new GanttLeftPanel();
    }

    toggleDatesColumns() {
        element(By.$('#toggleIsDatesColumnsShown')).click();
        browser.waitForAngular();
        return this;
    }
}

class GanttLeftPanel {
    constructor() {
        this.leftPanelSelector = '#gantt .gantt_grid_data';
    }

    getRow(title) {
        return new GanttRow(`${this.leftPanelSelector} .gantt-row:contains('${title}')`);
    }

    expectPlanningDataColumnsHidden() {
        expect(element.all(By.$(`${this.leftPanelSelector} .gantt_row:first .gantt_cell`)).count()).toEqual(1);
        return this;
    }

    expectPlanningDateColumnsShown() {
        let firstRow = element.all(By.css(`${this.leftPanelSelector} .gantt_row`)).get(0);
        expect(firstRow.all(By.css('.gantt_cell')).count()).toEqual(4);
        return this;
    }
}

class GanttRow {
    constructor(selector) {
        this.selector = selector;
    }

    setDuration(duration) {
        let dateTimePicker = new DurationPicker(`${this.selector} [duration-editor]:first`);
        dateTimePicker.setDuration(duration);
        return this;
    }

    expectDurationToBe(duration) {
        let durationPicker = new DurationPicker(`${this.selector} [duration-editor]:first`);
        durationPicker.expectDurationToBe(duration);
        return this;
    }

    removeDuration() {
        let durationPicker = new DurationPicker(`${this.selector} [duration-editor]:first`);
        durationPicker.removeDuration();
        return this;
    }

    expectNoDuration() {
        let durationPicker = new DurationPicker(`${this.selector} [duration-editor]:first`);
        durationPicker.expectNoDuration();
        return this;
    }

    setStartDate(date) {
        let dateTimePicker = new DateTimePicker(`${this.selector} .date-editor:first`);
        dateTimePicker.setDateTime(date);
        return this;
    }

    setEndDate(date) {
        let dateTimePicker = new DateTimePicker(`${this.selector} .date-editor:last`);
        dateTimePicker.setDateTime(date);
        return this;
    }

    removeStartDate() {
        let dateTimePicker = new DateTimePicker(`${this.selector} .date-editor:first`);
        dateTimePicker.removeDate();
        return this;
    }

    removeEndDate() {
        let dateTimePicker = new DateTimePicker(`${this.selector} .date-editor:last`);
        dateTimePicker.removeDate();
        return this;
    }

    toggleStartDateDatePicker() {
        new DateTimePicker(`${this.selector} .date-editor:first`).openDatePicker();
        return this;
    }

    expectStartDateToBe(dateFormat, timeFormat, date) {
        let dateTimePicker = new DateTimePicker(`${this.selector} .date-editor:first`);
        dateTimePicker.expectDateToBe(dateFormat, date);
        dateTimePicker.expectTimeToBe(timeFormat, date);
        return this;
    }

    expectStartDateToBeInferred() {
        let dateTimePicker = new DateTimePicker(`${this.selector} .date-editor:first`);
        dateTimePicker.expectDateToBeInferred();
        return this;
    }

    expectNoStartDate() {
        let dateTimePicker = new DateTimePicker(`${this.selector} .date-editor:first`);
        dateTimePicker.expectNoDate();
        return this;
    }

    expectEndDateToBe(dateFomat, timeFormat, date) {
        let dateTimePicker = new DateTimePicker(`${this.selector} .date-editor:last`);
        dateTimePicker.expectDateToBe(dateFomat, date);
        dateTimePicker.expectTimeToBe(timeFormat, date);
        return this;
    }

    expectEndDateToBeInferred() {
        let dateTimePicker = new DateTimePicker(`${this.selector} .date-editor:last`);
        dateTimePicker.expectDateToBeInferred();
        return this;
    }

    expectNoEndDate() {
        let dateTimePicker = new DateTimePicker(`${this.selector} .date-editor:last`);
        dateTimePicker.expectNoDate();
        return this;
    }

    expectStartDateNotDeletable() {
        let dateTimePicker = new DateTimePicker(`${this.selector} .date-editor:first`);
        dateTimePicker.expectDateNotDeletable();
        return this;
    }

    expectEndDateNotDeletable() {
        let dateTimePicker = new DateTimePicker(`${this.selector} .date-editor:last`);
        dateTimePicker.expectDateNotDeletable();
        return this;
    }
}

global.ReleaseGanttPage = ReleaseGanttPage;
