class InlineEditor {
    constructor(path) {
        this.path = path;
        Browser.waitFor(this.path);
        this.inlineEditor = element(By.$(this.path));
    }

    set(text) {
        browser.executeScript("arguments[0].scrollIntoView();", this.inlineEditor.getWebElement());
        this.focus();
        this.enter(text);
        return this.blur();
    }

    focus() {
        this.inlineEditor.element(By.css(".display")).click();
        return this;
    }

    deselect() {
        this.inlineEditor.element(By.css(".editable")).sendKeys(protractor.Key.LEFT);
        return this;
    }

    enter(text) {
        Browser.waitFor(`${this.path} .editable`, 3000);
        return this.inlineEditor.element(By.css(".editable")).sendKeys(text);
    }

    select(value) {
        this.focus();
        this.inlineEditor.element(By.$(`option:contains('${value}')`)).click();
        return this.blur();
    }

    expectOptionNotPresent(value) {
        this.focus();
        expect(element(By.$(`${this.path} option:contains('${value}')`)).isPresent()).toBe(false);
        return this.blur();
    }

    value() {
        return this.inlineEditor.element(By.css("span.text span")).getText();
    }

    editorValue() {
        return this.inlineEditor.element(By.css(".editable")).getAttribute('value');
    }

    blur() {
        Browser.clickElseWhere();
        return this;
    }
}


class AutoCompleteInlineEditor extends InlineEditor {
    set(value) {
        this.focus();
        this.enter(value);
        return this.chooseCandidate(value);
    }

    chooseCandidate(candidate) {
        Browser.waitFor(`.ui-autocomplete:visible .ui-menu-item:contains('${candidate}')`);
        return element(By.$(`.ui-autocomplete:visible .ui-menu-item:contains('${candidate}')`)).click();
    }
}

class UserInlineEditor extends AutoCompleteInlineEditor {
    enter(text) {
        return this.inlineEditor.element(by.model('draft.username')).sendKeys(text);
    }
}

class TextareaInlineEditor extends InlineEditor {
    focus() {
        // relies on a click on a span::before (not actionnable directly by Protractor)
        let clickOnEditIcon = function () {
            return $(`${arguments[0]} .edit-icon`).click();
        };
        Browser.executeVoidScript(clickOnEditIcon, this.path);
        return this;
    }

    set(text) {
        this.focus();
        this.enter(text);
        return this.inlineEditor.element(By.css('.ok')).click();
    }
}


global.InlineEditor = InlineEditor;
global.TextareaInlineEditor = TextareaInlineEditor;
global.AutoCompleteInlineEditor = AutoCompleteInlineEditor;
global.UserInlineEditor = UserInlineEditor;
