class FoldersPermissionsPage {
    constructor() {
        Browser.waitFor('#permissions .table');
    }

    check(role, permission) {
        element(By.$(`tr:contains('${role}') .permission-${permission} .permission-unchecked:visible`)).click();
        return this;
    }

    uncheck(role, permission) {
        element(`tr:contains('${role}') .permission-${permission} .permission-checked:visible`).click();
        return this;
    }

    save() {
        element(By.$(".save")).click();
        return this;
    }

    reset() {
        element(By.$(".reset")).click();
        return this;
    }

    removePermission(permission, team) {
        element(By.$(`.permissions-table-v2 tr.ng-scope:contains(${permission}) .tag:contains(${team}) .remove-icon`)).click();
        return this;
    }

    expectPermissionToExist(permission, team) {
        expect(element(By.$(`.permissions-table-v2 tr.ng-scope:contains(${permission}) .tag:contains(${team})`))).toBePresent(true);
        return this;
    }

    expectPermissionToNotExist(permission, team) {
        expect(element(By.$(`.permissions-table-v2 tr.ng-scope:contains(${permission}) .tag:contains(${team})`))).toBePresent(false);
        return this;
    }

    removeTeam(team) {
        element(By.$(`#teams-permissions-table .permissions-table tr:contains(${team}) .remove-action`)).click();
        element(By.$('.continue')).click();
        return this;
    }

    expectChecked(role, permission) {
        expect(element.all(By.$(`tr:contains('${role}') .permission-${permission} .permission-checked:visible`)).count()).toEqual(1);
        return this;
    }

    expectUnchecked(role, permission) {
        expect(element.all(By.$(`tr:contains('${role}') .permission-${permission} .permission-unchecked:visible`)).count()).toEqual(1);
        return this;
    }

    expectInheritMessagePresent(folder) {
        expect(element(By.$("p.inherit-checkbox")).getText()).toContain(`Inherit teams and permissions from parent folder ${folder}`);
        return this;
    }
}

global.FoldersPermissionsPage = FoldersPermissionsPage;
