class SingleTaskPage {
    constructor() {
        Browser.waitFor('#single-task');
    }

    expectReleaseLinksDisplayed(releaseTitle, displayed = true) {
        if (displayed) {
            expect(element(By.$(`a:contains('${releaseTitle}')`))).toBePresent();
            expect(element(By.$(".view-in-release"))).toBeDisplayed();
        } else {
            expect(element(By.$(`a:contains('${releaseTitle}')`))).not.toBePresent();
            expect(element(By.$(".view-in-release"))).not.toBeDisplayed();
        }
        return this;
    }

    expectTaskTitle(taskTitle) {
        expect(element(By.$(`.task-line:contains('${taskTitle}')`))).toBeDisplayed();
        return this;
    }

    expectEndDateShown() {
        expect(element(By.$(".date.calendar-link:contains('End')"))).toBeDisplayed();
        return this;
    }
}

global.SingleTaskPage = SingleTaskPage;
