class TaskAccessPage {
    constructor() {
        Browser.waitFor('#task-access');
    }

    setTaskAvailableToAllUsers(taskType, available) {
        let checkBox = element(By.$(`#task-access table tr:contains('${taskType}') input[type=checkbox]`));
        return checkBox.isSelected().then(function (selected) {
            if (selected !== available) {
                return checkBox.click();
            }
        });
    }

    save() {
        element(By.$('#task-access .save')).click();
        return Browser.waitFor(".last-saved");
    }
}


global.TaskAccessPage = TaskAccessPage;
