class FolderReleases {
    constructor() {
        Browser.waitFor('folder-release-list');
    }

    static open(folderId) {
        browser.setLocation(`/folders/${folderId}/releases`);
        return new FolderReleases();
    }

    static openReleasesFiltered(folderId, status) {
        browser.setLocation(`/folders/${folderId}/releases?has_filter&` + status);
        return new FolderReleases();
    }

    expectReleasesStarted(...releases) {
        let list = new ReleasesListPage();
        for (let release of releases) {
            list.expectReleaseStarted(release);
        }
        return this;
    }

    expectReleasesPlanned(...releases) {
        let list = new ReleasesListPage();
        return releases.map((release) =>
            list.expectReleasePlanned(release));
    }

    expectReleasesArchived(...releases) {
        let list = new ReleasesListPage();
        for (let release of releases) {
            list.expectReleaseArchived(release);
        }
        return this;
    }

    expectReleasesCompleted(...releases) {
        let list = new ReleasesListPage();
        for (let release of releases) {
            list.expectReleaseCompleted(release);
        }
        return this;
    }

    expectReleasesAborted(...releases) {
        let list = new ReleasesListPage();
        for (let release of releases) {
            list.expectReleasePlanned(release);
        }
        return this;
    }

    expectReleasesDisplayed(releases) {
        for (let title in releases) {
            let expected = releases[title];
            if (expected.displayed && expected.index >= 0) {
                expect(element(By.$(`.release:nth('${expected.index}') .release-title`)).getText()).toContain(title);
            }
            if (expected.phaseTitle && expected.index >= 0) {
                expect(element(By.$(`.release:nth('${expected.index}') .phase-title`)).getText()).toContain(expected.phaseTitle);
            }
        }
        return this;
    }

}

global.FolderReleases = FolderReleases;
