/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.model.CiSpec;
import com.xebialabs.ascode.yaml.model.Definition;
import com.xebialabs.ascode.yaml.model.Spec;
import com.xebialabs.ascode.yaml.model.permission.PermissionsSpec;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;
import com.xebialabs.xlrelease.ascode.service.ImportIncludes;
import com.xebialabs.xlrelease.ascode.service.ImportResult;
import com.xebialabs.xlrelease.ascode.service.spec.CiSpecInterpreter;
import com.xebialabs.xlrelease.ascode.service.spec.PermissionsSpecInterpreter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Option;
import scala.reflect.ScalaSignature;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0005\r4A!\u0002\u0004\u0001#!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0011\u0015I\u0003\u0001\"\u0001+\u00055IU\u000e]8siN+'O^5dK*\u0011q\u0001C\u0001\bg\u0016\u0014h/[2f\u0015\tI!\"\u0001\u0004bg\u000e|G-\u001a\u0006\u0003\u00171\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u00055q\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005y\u0011aA2p[\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\u0006Q1-[%na>\u0014H/\u001a:\u0011\u0005iiR\"A\u000e\u000b\u0005q1\u0011\u0001B:qK\u000eL!AH\u000e\u0003#\rK7\u000b]3d\u0013:$XM\u001d9sKR,'/A\nqKJl\u0017n]:j_:\u001c\u0018*\u001c9peR,'\u000f\u0005\u0002\u001bC%\u0011!e\u0007\u0002\u001b!\u0016\u0014X.[:tS>t7o\u00159fG&sG/\u001a:qe\u0016$XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0015:\u0003\u0006\u0005\u0002'\u00015\ta\u0001C\u0003\u0019\u0007\u0001\u0007\u0011\u0004C\u0003 \u0007\u0001\u0007\u0001%A\u0004qe>\u001cWm]:\u0015\t-r3G\u0010\t\u0003M1J!!\f\u0004\u0003\u0019%k\u0007o\u001c:u%\u0016\u001cX\u000f\u001c;\t\u000b=\"\u0001\u0019\u0001\u0019\u0002\u001d%l\u0007o\u001c:u\u0013:\u001cG.\u001e3fgB\u0011a%M\u0005\u0003e\u0019\u0011a\"S7q_J$\u0018J\\2mk\u0012,7\u000fC\u00035\t\u0001\u0007Q'\u0001\u0006eK\u001aLg.\u001b;j_:\u0004\"A\u000e\u001f\u000e\u0003]R!\u0001O\u001d\u0002\u000b5|G-\u001a7\u000b\u0005iZ\u0014\u0001B=b[2T!!\u0003\u0007\n\u0005u:$A\u0003#fM&t\u0017\u000e^5p]\")q\b\u0002a\u0001\u0001\u000691oY7ECR\f\u0007cA\nB\u0007&\u0011!\t\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0011[U\"A#\u000b\u0005\u0019;\u0015a\u00013u_*\u0011\u0001*S\u0001\u0004G>\u001c'B\u0001&\r\u0003)AH\u000e\u001d7bi\u001a|'/\\\u0005\u0003\u0019\u0016\u00131cU\"N)J\f7-Z1cS2LG/\u001f#bi\u0006D#\u0001\u0001(\u0011\u0005=SV\"\u0001)\u000b\u0005E\u0013\u0016AC1o]>$\u0018\r^5p]*\u00111\u000bV\u0001\bM\u0006\u001cGo\u001c:z\u0015\t)f+A\u0003cK\u0006t7O\u0003\u0002X1\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001Z\u0003\ry'oZ\u0005\u00037B\u0013\u0011\"Q;u_^L'/\u001a3)\u0005\u0001i\u0006C\u00010b\u001b\u0005y&B\u00011W\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0003E~\u0013qaU3sm&\u001cW\r")
public class ImportService {
    private final CiSpecInterpreter ciImporter;
    private final PermissionsSpecInterpreter permissionsImporter;

    public ImportResult process(ImportIncludes importIncludes, Definition definition, Option<SCMTraceabilityData> scmData) {
        ImportResult importResult;
        Spec spec = definition.spec();
        if (spec instanceof CiSpec) {
            importResult = this.ciImporter.importDefinition(importIncludes, definition, scmData);
        } else if (spec instanceof PermissionsSpec) {
            importResult = this.permissionsImporter.importDefinition(importIncludes, definition, scmData);
        } else {
            throw new AsCodeException(new StringBuilder(36).append(definition.spec().getClass()).append(" not supported in import service yet").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return importResult;
    }

    public ImportService(CiSpecInterpreter ciImporter, PermissionsSpecInterpreter permissionsImporter) {
        this.ciImporter = ciImporter;
        this.permissionsImporter = permissionsImporter;
    }
}

