package com.xebialabs.xlrelease.api.v1

import com.xebialabs.ascode.yaml.writer.DefinitionWriter.WriterConfig
import com.xebialabs.deployit.core.rest.resteasy.Workdir
import com.xebialabs.deployit.core.rest.resteasy.Workdir.Clean.ONLY_ON_EXCEPTION
import com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN
import com.xebialabs.xlrelease.api.ApiService
import com.xebialabs.xlrelease.ascode.service.GenerateService
import com.xebialabs.xlrelease.ascode.utils.StaticVariables
import com.xebialabs.xlrelease.ascode.yaml.writer.XLRDefinitionWriter
import com.xebialabs.xlrelease.domain.{ExportConfig, ExportResult, FolderExportConfig, GlobalExportConfig}
import com.xebialabs.xlrelease.rest.AllCILevels
import com.xebialabs.xlrelease.security.PermissionChecker
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

import java.util.{ArrayList => JArrayList, List => JList}
import javax.ws.rs.core.MediaType
import javax.ws.rs.{Consumes, POST, Path, Produces}
import scala.jdk.CollectionConverters._

@Path("/api/v1/as-code")
@Consumes(Array(MediaType.APPLICATION_JSON))
@AllCILevels // TODO - what is this?  All APIs set it but don't see any code that uses it
@Controller
//@PublicApi
//@ShowOnlyPublicApiMembers
class AsCodeApi @Autowired()(generateService: GenerateService, permissionChecker: PermissionChecker) extends ApiService {
  override def serviceName() = "asCodeApi"

  @POST
  @Produces(Array("text/vnd.yaml"))
  @Workdir(prefix = StaticVariables.AS_CODE_GENERATE_PREFIX, clean = ONLY_ON_EXCEPTION)
  @Path("/folder-export")
  def folderExport(exportConfigs: JList[FolderExportConfig]): JList[ExportResult] = {
    exportConfigs.asScala.map(exportConfig => {
      FolderExportConfig.validateAndNormalize(exportConfig)
      val definitions = generateService.generate(FolderExportConfig.toGeneratorConfig(exportConfig, permissionChecker.hasGlobalPermission(ADMIN)))
      val result = new ExportResult
      result.yaml = XLRDefinitionWriter().writeYamlAsString(WriterConfig(definitions, false, false), true)
      result
    }).toList.asJava
  }

  @POST
  @Produces(Array("text/vnd.yaml"))
  @Workdir(prefix = StaticVariables.AS_CODE_GENERATE_PREFIX, clean = ONLY_ON_EXCEPTION)
  @Path("/global-export")
  def globalExport(exportConfigs: JList[GlobalExportConfig]): JList[ExportResult] = {
    exportConfigs.asScala.map(exportConfig => {
      GlobalExportConfig.validateAndNormalize(exportConfig)
      val definitions = generateService.generate(GlobalExportConfig.toGeneratorConfig(exportConfig, permissionChecker.hasGlobalPermission(ADMIN)))
      val result = new ExportResult
      result.yaml = XLRDefinitionWriter().writeYamlAsString(WriterConfig(definitions, false, false), true)
      result
    }).toList.asJava
  }

  @POST
  @Produces(Array("text/vnd.yaml"))
  @Workdir(prefix = StaticVariables.AS_CODE_GENERATE_PREFIX, clean = ONLY_ON_EXCEPTION)
  @Path("/export")
  def fullExport(exportConfig: ExportConfig): JList[ExportResult] = {
    val results = new JArrayList[ExportResult]
    if (!exportConfig.globalConfigs.isEmpty) {
      results.addAll(globalExport(exportConfig.globalConfigs))
    }
    if (!exportConfig.folderConfigs.isEmpty) {
      results.addAll(folderExport(exportConfig.folderConfigs))
    }
    results
  }
}
