package com.xebialabs.xlrelease.ascode.service.generatestrategy

import com.xebialabs.xlrelease.ascode.utils.Utils
import com.xebialabs.xlrelease.configuration._
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.notifications.service.SmtpConfigurationService
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.collection.immutable.ListMap
import scala.collection.mutable.ListBuffer


@Component
class SettingsAsCodeGenerator @Autowired()(configurationRepository: ConfigurationRepository,
                                           smtpConfigurationService: SmtpConfigurationService) extends GenerateStrategy[BaseConfiguration] {

  override val generateOrder: Double = 100

  override def isDefinedAt(config: CiGenerateConfig): Boolean = {
    config.generateConfig.generateSettings
  }

  override protected def generateGlobal(config: CiGenerateConfig): ListMap[Option[Folder], List[BaseConfiguration]] = {
    val settings = ListBuffer.empty[BaseConfiguration]

    // general settings page
    if (config.isAdminUser) {
      settings += configurationRepository.read(TemplateVersioningSettings.TEMPLATE_VERSIONING_ID)
      settings += configurationRepository.getThemeSettings
      settings += configurationRepository.read(ReportsSettings.REPORTS_SETTINGS_ID)
      settings += configurationRepository.read(PollingSettings.POLLING_SETTINGS_ID)
      settings += configurationRepository.read(ArchivingSettings.ARCHIVING_SETTINGS_ID)
      settings += configurationRepository.read(AuditReportSettings.AUDIT_REPORT_SETTINGS_ID)
      settings += smtpConfigurationService.getSmtpServerSettings
      settings += configurationRepository.read(TriggerDataPurgeSettings.TRIGGER_DATA_PURGE_SETTINGS_ID)
    }
    ListMap(None -> settings.toList)
  }

  override protected def filter(results: ListMap[Option[Folder], List[BaseConfiguration]], ciTitle: String):
  ListMap[Option[Folder], List[BaseConfiguration]] = {
    results.map { case (maybeFolder, cis) =>
      maybeFolder -> cis.filter { ci =>
        Utils.stringLike(ci.getType.toString, ciTitle)
      }
    }
  }
}
