/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.ascode.metadata.MetadataFields$;
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService$;
import com.xebialabs.xlrelease.ascode.service.ImportResult;
import com.xebialabs.xlrelease.ascode.service.PostCommitAction;
import com.xebialabs.xlrelease.ascode.service.ReferenceSolver;
import com.xebialabs.xlrelease.ascode.utils.ImportContext;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger;
import com.xebialabs.xlrelease.triggers.events.TriggerCreatedFromAsCodeEvent;
import com.xebialabs.xlrelease.triggers.events.TriggerUpdatedFromAsCodeEvent;
import com.xebialabs.xlrelease.triggers.service.TriggerService;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerLifecycle;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.versioning.ascode.ImportValidator;
import com.xebialabs.xlrelease.versioning.ascode.ValidationMessage;
import com.xebialabs.xlrelease.webhooks.mapping.MappedProperty;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\tEa\u0001B\u000e\u001d\u0001\u001dB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!Y\u0005A!A!\u0002\u0013a\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\t\u0011\u0001\u0004!\u0011!Q\u0001\n\u0005D\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0005U\")\u0001\u000f\u0001C\u0001c\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\b\u0003\u0007\u0002A\u0011BA#\u0011\u001d\t)\u0007\u0001C\u0005\u0003OBq!!\u001d\u0001\t\u0013\t\u0019\bC\u0004\u0002\u001a\u0002!I!a'\t\u000f\u0005\r\u0006\u0001\"\u0003\u0002&\"9\u0011Q\u0017\u0001\u0005\n\u0005]\u0006bBA_\u0001\u0011%\u0011q\u0018\u0005\b\u0003\u000b\u0004A\u0011BAd\u0011\u001d\ti\r\u0001C\u0005\u0003\u001fDq!a8\u0001\t\u0013\t\t\u000fC\u0004\u0002h\u0002!I!!;\t\u000f\u00055\b\u0001\"\u0003\u0002p\"9\u00111\u001f\u0001\u0005\n\u0005U\bbBA}\u0001\u0011%\u00111 \u0002\u0015)JLwmZ3s\u0003N\u001cu\u000eZ3TKJ4\u0018nY3\u000b\u0005uq\u0012aB:feZL7-\u001a\u0006\u0003?\u0001\na!Y:d_\u0012,'BA\u0011#\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002$I\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002K\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u000b\u0018\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g!\tyC'D\u00011\u0015\t\t$'A\u0003tY\u001a$$NC\u00014\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001b1\u0005\u001daunZ4j]\u001e\f\u0011\u0003\u001e:jO\u001e,'OU3q_NLGo\u001c:z!\tA4(D\u0001:\u0015\tQ\u0004%\u0001\u0006sKB|7/\u001b;pefL!\u0001P\u001d\u0003#Q\u0013\u0018nZ4feJ+\u0007o\\:ji>\u0014\u00180A\tsK2,\u0017m]3SKB|7/\u001b;pef\u0004\"\u0001O \n\u0005\u0001K$!\u0005*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\u0006q!/\u001a7fCN,7+\u001a:wS\u000e,\u0007CA\"F\u001b\u0005!%BA\u000f!\u0013\t1EI\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\u0002\u001b\u0019|G\u000eZ3s'\u0016\u0014h/[2f!\t\u0019\u0015*\u0003\u0002K\t\niai\u001c7eKJ\u001cVM\u001d<jG\u0016\fqB]3gKJ,gnY3T_24XM\u001d\t\u0003\u001b:k\u0011\u0001H\u0005\u0003\u001fr\u0011qBU3gKJ,gnY3T_24XM]\u0001\u0011iJLwmZ3s\u0019&4WmY=dY\u0016\u00042A\u0015-[\u001b\u0005\u0019&B\u0001+V\u0003\u0011IW\u000e\u001d7\u000b\u0005u1&BA,!\u0003!!(/[4hKJ\u001c\u0018BA-T\u0005A!&/[4hKJd\u0015NZ3ds\u000edW\r\u0005\u0002\\=6\tAL\u0003\u0002^A\u00051Am\\7bS:L!a\u0018/\u0003\u000fQ\u0013\u0018nZ4fe\u0006Y1-[%e'\u0016\u0014h/[2f!\t\u0019%-\u0003\u0002d\t\nY1)[%e'\u0016\u0014h/[2f\u00039!(/[4hKJ\u001cVM\u001d<jG\u0016\u0004\"AZ4\u000e\u0003UK!\u0001[+\u0003\u001dQ\u0013\u0018nZ4feN+'O^5dK\u0006AQM^3oi\n+8\u000f\u0005\u0002l]6\tAN\u0003\u0002nA\u00051QM^3oiNL!a\u001c7\u0003#ac%+\u001a7fCN,WI^3oi\n+8/\u0001\u0004=S:LGO\u0010\u000b\u000beN$XO^<ysj\\\bCA'\u0001\u0011\u00151$\u00021\u00018\u0011\u0015i$\u00021\u0001?\u0011\u0015\t%\u00021\u0001C\u0011\u00159%\u00021\u0001I\u0011\u0015Y%\u00021\u0001M\u0011\u0015\u0001&\u00021\u0001R\u0011\u0015\u0001'\u00021\u0001b\u0011\u0015!'\u00021\u0001f\u0011\u0015I'\u00021\u0001kQ\tQQ\u0010E\u0002\u007f\u0003'i\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0006b]:|G/\u0019;j_:TA!!\u0002\u0002\b\u00059a-Y2u_JL(\u0002BA\u0005\u0003\u0017\tQAY3b]NTA!!\u0004\u0002\u0010\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002\u0012\u0005\u0019qN]4\n\u0007\u0005UqPA\u0005BkR|w/\u001b:fI\u00069\u0001O]8dKN\u001cHCBA\u000e\u0003C\t\t\u0004E\u0002N\u0003;I1!a\b\u001d\u00051IU\u000e]8siJ+7/\u001e7u\u0011\u001d\t\u0019c\u0003a\u0001\u0003K\tqaY8oi\u0016DH\u000f\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\r\tYCH\u0001\u0006kRLGn]\u0005\u0005\u0003_\tICA\u0007J[B|'\u000f^\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003gY\u0001\u0019\u0001.\u0002\u000fQ\u0014\u0018nZ4fe\u0006q\u0001O]8dKN\u001cHK]5hO\u0016\u0014HCBA\u001d\u0003\u007f\t\t\u0005E\u0002*\u0003wI1!!\u0010+\u0005\u0011)f.\u001b;\t\u000f\u0005\rB\u00021\u0001\u0002&!1\u00111\u0007\u0007A\u0002i\u000baa\u0019:fCR,G\u0003CA\u000e\u0003\u000f\nI%a\u0013\t\u000f\u0005\rR\u00021\u0001\u0002&!1\u00111G\u0007A\u0002iCq!!\u0014\u000e\u0001\u0004\ty%A\u0005ue&<w-\u001a:JIB!\u0011\u0011KA0\u001d\u0011\t\u0019&a\u0017\u0011\u0007\u0005U#&\u0004\u0002\u0002X)\u0019\u0011\u0011\f\u0014\u0002\rq\u0012xn\u001c;?\u0013\r\tiFK\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00141\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005u#&\u0001\u0004va\u0012\fG/\u001a\u000b\t\u00037\tI'a\u001b\u0002p!9\u00111\u0005\bA\u0002\u0005\u0015\u0002BBA7\u001d\u0001\u0007!,\u0001\u0005fq&\u001cH/\u001b8h\u0011\u0019\t\u0019D\u0004a\u00015\u0006Aa/\u00197jI\u0006$X\r\u0006\u0004\u0002v\u0005U\u0015q\u0013\t\u0007\u0003o\n\t)a\"\u000f\t\u0005e\u0014Q\u0010\b\u0005\u0003+\nY(C\u0001,\u0013\r\tyHK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019)!\"\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u007fR\u0003\u0003BAE\u0003#k!!a#\u000b\u0007}\tiIC\u0002\u0002\u0010\u0002\n!B^3sg&|g.\u001b8h\u0013\u0011\t\u0019*a#\u0003#Y\u000bG.\u001b3bi&|g.T3tg\u0006<W\rC\u0004\u0002$=\u0001\r!!\n\t\r\u0005Mr\u00021\u0001[\u0003Y1\u0018\r\\5eCR,7\u000b^8sK\u0012$&/[4hKJ\u001cH\u0003BA\u001d\u0003;Cq!a(\u0011\u0001\u0004\t\t+\u0001\bti>\u0014X\r\u001a+sS\u001e<WM]:\u0011\u000b\u0005]\u0014\u0011\u0011.\u0002\u0019\u0019Lg\u000e\u001a+f[Bd\u0017\r^3\u0015\r\u0005\u001d\u0016QVAY!\rY\u0016\u0011V\u0005\u0004\u0003Wc&a\u0002*fY\u0016\f7/\u001a\u0005\b\u0003_\u000b\u0002\u0019AA(\u0003%IGm\u0014:USRdW\rC\u0004\u00024F\u0001\r!a\u0014\u0002\u0019A\f'/\u001a8u\r>dG-\u001a:\u0002!\u0019Lg\u000e\u001a+f[Bd\u0017\r^3Cs&#GCBAT\u0003s\u000bY\fC\u0004\u00020J\u0001\r!a\u0014\t\u000f\u0005M&\u00031\u0001\u0002P\u0005\u0019b-\u001b8e)\u0016l\u0007\u000f\\1uK\nKH+\u001b;mKR1\u0011qUAa\u0003\u0007Dq!a,\u0014\u0001\u0004\ty\u0005C\u0004\u00024N\u0001\r!a\u0014\u0002-I,7o\u001c7wKJ+G.Z1tK\u001a{G\u000eZ3s\u0013\u0012$B!a\u0014\u0002J\"9\u00111\u001a\u000bA\u0002\u0005=\u0013a\u0004:fY\u0016\f7/\u001a$pY\u0012,'/\u00133\u00021U\u0004H-\u0019;f)JLwmZ3sgB\u0013x\u000e]3si&,7\u000f\u0006\u0005\u0002:\u0005E\u00171[Ak\u0011\u0019\t\u0019$\u0006a\u00015\"9\u00111W\u000bA\u0002\u0005=\u0003bBAl+\u0001\u0007\u0011\u0011\\\u0001\u0005Q>lW\rE\u0003*\u00037\fy%C\u0002\u0002^*\u0012aa\u00149uS>t\u0017AC4f]\u0016\u0014\u0018\r^3JIR!\u0011qJAr\u0011\u001d\t)O\u0006a\u0001\u0003\u001f\n\u0001\u0002]1sK:$\u0018\nZ\u0001\u0011m\u0006d\u0017\u000eZ1uK\u001a{G\u000eZ3s\u0013\u0012$B!!\u000f\u0002l\"1\u00111G\fA\u0002i\u000bq\"\u001e9eCR,g+\u0019:jC\ndWm\u001d\u000b\u0005\u0003s\t\t\u0010\u0003\u0004\u00024a\u0001\rAW\u0001\u000eK:\f'\r\\3Ue&<w-\u001a:\u0015\t\u0005e\u0012q\u001f\u0005\u0007\u0003gI\u0002\u0019\u0001.\u0002-\r|\u0007/_%oi\u0016\u0014h.\u00197Qe>\u0004XM\u001d;jKN$b!!\u000f\u0002~\u0006}\bBBA75\u0001\u0007!\f\u0003\u0004\u0003\u0002i\u0001\rAW\u0001\u000fkB$\u0017\r^3e)JLwmZ3sQ\r\u0001!Q\u0001\t\u0005\u0005\u000f\u0011i!\u0004\u0002\u0003\n)!!1BA\u0006\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005\u001f\u0011IAA\u0004TKJ4\u0018nY3")
public class TriggerAsCodeService
implements Logging {
    private final TriggerRepository triggerRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final FolderService folderService;
    private final ReferenceSolver referenceSolver;
    private final TriggerLifecycle<Trigger> triggerLifecycle;
    private final CiIdService ciIdService;
    private final TriggerService triggerService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TriggerAsCodeService triggerAsCodeService = this;
        synchronized (triggerAsCodeService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public ImportResult process(ImportContext context, Trigger trigger) {
        ImportResult importResult;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(35).append("Processing trigger: ").append(trigger.toString()).append(" with metadata ").append(context.metadata().toString()).toString());
        String parentFolder = (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/");
        List storedTriggers = CollectionConverters$.MODULE$.ListHasAsScala(this.triggerRepository.findByFolderId(parentFolder, false, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE)).getContent()).asScala().toList();
        this.validateStoredTriggers((List<Trigger>)storedTriggers);
        this.processTrigger(context, trigger);
        Option option = storedTriggers.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$process$3(trigger, x$1)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Trigger existing = (Trigger)some.value();
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(18).append("Updating trigger: ").append(existing.toString()).toString());
            importResult = this.update(context, existing, trigger);
        } else if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> new StringBuilder(18).append("Creating trigger: ").append(trigger.toString()).toString());
            importResult = this.create(context, trigger, this.generateId(parentFolder));
        } else {
            throw new MatchError((Object)option);
        }
        return importResult;
    }

    private void processTrigger(ImportContext context, Trigger trigger) {
        String parentFolder = (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/");
        Option home = context.metadata().get((Object)MetadataFields$.MODULE$.HOMEFOLDER().toString());
        this.referenceSolver.resolveReferences((ConfigurationItem)trigger, context.references(), parentFolder);
        this.updateTriggersProperties(trigger, parentFolder, (Option<String>)home);
        this.validateFolderId(trigger);
        this.updateVariables(trigger);
        CiHelper.fixUpInternalReferences((ConfigurationItem)trigger);
    }

    private ImportResult create(ImportContext context, Trigger trigger, String triggerId) {
        trigger.setId(triggerId);
        Trigger created = this.triggerRepository.create(trigger);
        List<ValidationMessage> messages = this.validate(context, trigger);
        return new ImportResult((List<AsCodeResponse.ChangedIds>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AsCodeResponse.ChangedIds[]{AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withCreated(created.getId())}))), (scala.collection.immutable.Seq<PostCommitAction>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PostCommitAction[]{() -> this.enableTrigger(created), () -> $this.eventBus.publish((XLReleaseEvent)new TriggerCreatedFromAsCodeEvent(created, context.scmData()))}))), (Map<String, Map<Type, AsCodeResponse.ChangedIds>>)Predef$.MODULE$.Map().empty(), messages);
    }

    private ImportResult update(ImportContext context, Trigger existing, Trigger trigger) {
        trigger.setId(existing.getId());
        trigger.setCiUid(existing.getCiUid());
        this.copyInternalProperties(existing, trigger);
        List<ValidationMessage> messages = this.validate(context, trigger);
        Trigger updated = this.triggerRepository.update(trigger);
        return new ImportResult((List<AsCodeResponse.ChangedIds>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AsCodeResponse.ChangedIds[]{AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withUpdated(updated.getId())}))), (scala.collection.immutable.Seq<PostCommitAction>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new PostCommitAction[]{() -> $this.triggerService.refreshTrigger(updated), () -> this.enableTrigger(updated), () -> $this.eventBus.publish((XLReleaseEvent)new TriggerUpdatedFromAsCodeEvent(updated, context.scmData()))}))), (Map<String, Map<Type, AsCodeResponse.ChangedIds>>)Predef$.MODULE$.Map().empty(), messages);
    }

    private List<ValidationMessage> validate(ImportContext context, Trigger trigger) {
        List list;
        Option<ImportValidator> option = context.validator();
        if (option instanceof Some) {
            Some some = (Some)option;
            ImportValidator validator = (ImportValidator)some.value();
            list = validator.validateCi((ConfigurationItem)trigger, context.getFolderInfo()).toList();
        } else if (None$.MODULE$.equals(option)) {
            list = package$.MODULE$.List().empty();
        } else {
            throw new MatchError(option);
        }
        return list;
    }

    private void validateStoredTriggers(List<Trigger> storedTriggers) {
        ((IterableOnceOps)storedTriggers.groupBy((Function1 & Serializable)x$2 -> x$2.getTitle()).values().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$validateStoredTriggers$2(x$3)))).foreach((Function1 & Serializable)triggerGroup -> {
            Trigger trigger = (Trigger)triggerGroup.head();
            throw new AsCodeException(new StringBuilder(99).append("More than one trigger with the name [").append(trigger.getTitle()).append("] is present in the repository. Don't know which one to update").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        });
    }

    public Release com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$findTemplate(String idOrTitle, String parentFolder) {
        return Ids.isReleaseId((String)idOrTitle) ? this.findTemplateById(idOrTitle, parentFolder) : this.findTemplateByTitle(idOrTitle, parentFolder);
    }

    private Release findTemplateById(String idOrTitle, String parentFolder) {
        Release release;
        try {
            release = this.releaseService.findById(idOrTitle);
        }
        catch (LogFriendlyNotFoundException nfe) {
            release = this.findTemplateByTitle(idOrTitle, parentFolder);
        }
        catch (Exception e) {
            throw new AsCodeException(new StringBuilder(37).append("Failed to find template [").append(idOrTitle).append("], error [").append(e.getMessage()).append("].").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return release;
    }

    private Release findTemplateByTitle(String idOrTitle, String parentFolder) {
        Release template;
        block6: {
            List list;
            boolean bl;
            block5: {
                bl = false;
                .colon.colon colon2 = null;
                list = CollectionConverters$.MODULE$.ListHasAsScala(this.releaseService.findTemplatesByTitle(parentFolder, idOrTitle, 0, 2, 1)).asScala().toList();
                if (!(list instanceof .colon.colon)) break block5;
                bl = true;
                colon2 = (.colon.colon)list;
                template = (Release)colon2.head();
                List list2 = colon2.next$access$1();
                Nil$ nil$ = package$.MODULE$.Nil();
                List list3 = list2;
                if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) break block6;
            }
            if (bl) {
                throw new AsCodeException(new StringBuilder(91).append("More than one template with name [").append(idOrTitle).append("] is present in the folder [").append(parentFolder).append("]. Please use an unique name.").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            Nil$ nil$ = package$.MODULE$.Nil();
            List list4 = list;
            if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                throw new AsCodeException(new StringBuilder(49).append("There is no template with name [").append(idOrTitle).append("] under folder [").append(parentFolder).append("]").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            throw new MatchError((Object)list);
        }
        Release release = template;
        return release;
    }

    public String com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$resolveReleaseFolderId(String releaseFolderId) {
        String resolvedReleaseFolderID;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.folderService.findByPath(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(releaseFolderId), "/"), $this.folderService.findByPath$default$2()).getId());
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                throw new AsCodeException(new StringBuilder(67).append("Unable to resolve release folder id, ").append(releaseFolderId).append(" for trigger: failure message ").append(ex.getMessage()).toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        String string = resolvedReleaseFolderID = (String)success.value();
        return string;
    }

    private void updateTriggersProperties(Trigger trigger, String parentFolder, Option<String> home) {
        trigger.setFolderId(parentFolder);
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            releaseTrigger.setTemplate(this.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$findTemplate(releaseTrigger.getTemplate(), parentFolder).getId());
            releaseTrigger.setReleaseFolder((String)Option$.MODULE$.apply((Object)FolderAsCodeService$.MODULE$.absolutePath(releaseTrigger.getReleaseFolder(), home)).map((Function1 & Serializable)releaseFolderId -> this.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$resolveReleaseFolderId((String)releaseFolderId)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (trigger2 instanceof EventBasedTrigger) {
            EventBasedTrigger eventBasedTrigger = (EventBasedTrigger)trigger2;
            CollectionConverters$.MODULE$.ListHasAsScala(eventBasedTrigger.mappedProperties()).asScala().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$2(p))).collect((PartialFunction)new Serializable(this, parentFolder){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ TriggerAsCodeService $outer;
                private final String parentFolder$1;

                public final <A1 extends MappedProperty, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof MappedProperty.StringValue) {
                        MappedProperty.StringValue stringValue = (MappedProperty.StringValue)A1;
                        object = this.$outer.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$findTemplate(stringValue.value(), this.parentFolder$1);
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(MappedProperty x1) {
                    MappedProperty mappedProperty = x1;
                    boolean bl = mappedProperty instanceof MappedProperty.StringValue;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parentFolder$1 = parentFolder$1;
                }
            }).map((Function1 & Serializable)templateId -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$4(eventBasedTrigger, templateId)));
            eventBasedTrigger.mappedProperties().removeIf(p -> {
                String string = p.targetProperty();
                String string2 = "template";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            CollectionConverters$.MODULE$.ListHasAsScala(eventBasedTrigger.mappedProperties()).asScala().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$6(p))).collect((PartialFunction)new Serializable(this, home){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ TriggerAsCodeService $outer;
                private final Option home$1;

                public final <A1 extends MappedProperty, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof MappedProperty.StringValue) {
                        MappedProperty.StringValue stringValue = (MappedProperty.StringValue)A1;
                        object = this.$outer.com$xebialabs$xlrelease$ascode$service$TriggerAsCodeService$$resolveReleaseFolderId(FolderAsCodeService$.MODULE$.absolutePath(stringValue.value(), (Option<String>)this.home$1));
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(MappedProperty x2) {
                    MappedProperty mappedProperty = x2;
                    boolean bl = mappedProperty instanceof MappedProperty.StringValue;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.home$1 = home$1;
                }
            }).map((Function1 & Serializable)folderId -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateTriggersProperties$8(eventBasedTrigger, folderId)));
            eventBasedTrigger.mappedProperties().removeIf(p -> {
                String string = p.targetProperty();
                String string2 = "releaseFolder";
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
    }

    private String generateId(String parentId) {
        return this.ciIdService.getUniqueId(Type.valueOf(Trigger.class), parentId);
    }

    private void validateFolderId(Trigger trigger) {
        if (new FolderId(trigger.getFolderId()).absolute().equals(Ids.ROOT_FOLDER_ID)) {
            throw new AsCodeException(new StringBuilder(111).append("Failed to create trigger ").append(trigger.getTitle()).append(", you cannot create trigger on the root folder. The root folder path is not supported.").toString(), AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private void updateVariables(Trigger trigger) {
        Trigger trigger2 = trigger;
        if (trigger2 instanceof ReleaseTrigger) {
            ReleaseTrigger releaseTrigger = (ReleaseTrigger)trigger2;
            java.util.List variables = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.findById(releaseTrigger.getTemplate(), ResolveOptions$.MODULE$.WITH_DECORATORS()).getVariables()).asScala().filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateVariables$1(releaseTrigger, v)))).toList()).asJava();
            Release variableHolderTemplate = ReleaseBuilder.newRelease().withId(releaseTrigger.getTemplate()).withVariables(variables).build();
            variableHolderTemplate.setVariableValues(CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(releaseTrigger.getTemplateVariableValues(x$4 -> !x$4.isPassword())).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateVariables$3(x$5)))).asJava());
            variableHolderTemplate.setPasswordVariableValues(releaseTrigger.getTemplatePasswordVariables());
            releaseTrigger.setVariables(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(variableHolderTemplate.getVariables()).asScala().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TriggerAsCodeService.$anonfun$updateVariables$4(x$6)))).toList()).asJava());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void enableTrigger(Trigger trigger) {
        if (trigger.isEnabled()) {
            this.triggerLifecycle.enable(trigger, false);
        } else {
            this.triggerLifecycle.disable(trigger);
        }
    }

    private void copyInternalProperties(Trigger existing, Trigger updatedTrigger) {
        CollectionConverters$.MODULE$.ListHasAsScala(updatedTrigger.getInternalProperties()).asScala().foreach((Function1 & Serializable)internalProperty -> {
            updatedTrigger.setProperty(internalProperty, existing.getProperty(internalProperty));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$process$3(Trigger trigger$1, Trigger x$1) {
        String string = x$1.getTitle();
        String string2 = trigger$1.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateStoredTriggers$2(List x$3) {
        return x$3.length() > 1;
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$2(MappedProperty p) {
        String string = p.targetProperty();
        String string2 = "template";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$4(EventBasedTrigger x3$1, Release templateId) {
        MappedProperty.StringValue value = new MappedProperty.StringValue("templateId");
        value.setValue(templateId.getId());
        return x3$1.mappedProperties().add(value);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$6(MappedProperty p) {
        String string = p.targetProperty();
        String string2 = "releaseFolder";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$updateTriggersProperties$8(EventBasedTrigger x3$1, String folderId) {
        MappedProperty.StringValue value = new MappedProperty.StringValue("releaseFolderId");
        value.setValue(folderId);
        return x3$1.mappedProperties().add(value);
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$1(ReleaseTrigger x2$1, Variable v) {
        return x2$1.getVariablesByKeys().containsKey(v.getKey());
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$3(Tuple2 x$5) {
        return x$5._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$updateVariables$4(Variable x$6) {
        return x$6.getId() != null;
    }

    @Autowired
    public TriggerAsCodeService(TriggerRepository triggerRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, FolderService folderService, ReferenceSolver referenceSolver, TriggerLifecycle<Trigger> triggerLifecycle, CiIdService ciIdService, TriggerService triggerService, XLReleaseEventBus eventBus) {
        this.triggerRepository = triggerRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.folderService = folderService;
        this.referenceSolver = referenceSolver;
        this.triggerLifecycle = triggerLifecycle;
        this.ciIdService = ciIdService;
        this.triggerService = triggerService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

