package com.xebialabs.xlrelease.versioning.ascode.scm

import com.xebialabs.xlrelease.ascode.yaml.parser.ValueTagPreprocessingConstructor
import org.yaml.snakeyaml.Yaml

import scala.collection.mutable.ListBuffer

object YamlUtils {

  def preprocessYaml(yamlStr: String): List[String] = {
    // TODO add tag handling during definition parsing to avoid additional parsing of yaml and converting back
    val processedYamlStrs = ListBuffer.empty[String]
    val yamlParser = new Yaml(new ValueTagPreprocessingConstructor)
    val data = yamlParser.loadAll(yamlStr)
    data.forEach { spec =>
      if (spec != null) {
        processedYamlStrs.addOne(yamlParser.dump(spec))
      }
    }

    processedYamlStrs.toList
  }
}
