package com.xebialabs.xlrelease.versioning.ascode

import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings
import com.xebialabs.xlrelease.events.{AsyncSubscribe, EventListener, XLReleaseEventListener}
import com.xebialabs.xlrelease.repository.{FolderRepository, PersistenceInterceptor}
import com.xebialabs.xlrelease.versioning.ascode.actors.FolderVersioningActorService
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
@EventListener
class FolderVersioningEventHandler @Autowired()(folderVersioningActorService: FolderVersioningActorService,
                                                folderRepository: FolderRepository)
  extends XLReleaseEventListener with Logging with PersistenceInterceptor[Folder] {

  folderRepository.registerPersistenceInterceptor(this)

  // todo delete local repo when branch or connector change
  @AsyncSubscribe
  def onConfigurationDelete(event: ConfigurationDeletedEvent): Unit = {
    event.conf match {
      case config: FolderVersioningSettings => this.onDelete(config.getFolderId)
      case _ => // nothing
    }
  }

  override def onDelete(ciId: String): Unit = try {
    folderVersioningActorService.cleanLocalRepo(ciId, clusterWide = true)
  } catch {
    case e: Exception => logger.warn(s"Unable to clean folder version control work dir for folder $ciId", e)
  }
}
