package com.xebialabs.xlrelease.versioning.ascode.scm.strategy

import com.xebialabs.ascode.yaml.model.Definition
import com.xebialabs.xlrelease.domain.versioning.ascode.FolderVersioningSettings
import com.xebialabs.xlrelease.scm.connector.ScmBlobs
import com.xebialabs.xlrelease.versioning.ascode.scm.connector.AsCodeJGitConnector

trait VersioningStyleStrategy {

  def generateFolder(folderId: String, settings: FolderVersioningSettings): FolderContent

  def fetchChildDefinitionsIfNecessary(version: String,
                                       scmPath: String,
                                       scmConnector: AsCodeJGitConnector,
                                       releasefileDefinitions: List[Definition]): List[Definition]

  def getDefinitionsFilenamesFrom(definition: Definition): List[String]

  def getVersionableFileNames(folderId: String, folderVersioningSettings: FolderVersioningSettings): List[String]

  def name: String

  def value: String

  def maxNumOfFilesGenerated: Integer

}

case class FolderContent(blob: ScmBlobs, definitions: List[Definition], secrets: Map[String, String])