package com.xebialabs.xlrelease.ascode.service.generatestrategy

import com.xebialabs.xlrelease.ascode.utils.Utils.enforcePermissionsOnGenerate
import com.xebialabs.xlrelease.domain.folder.Folder
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard
import com.xebialabs.xlrelease.plugins.dashboard.service.DashboardService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.Collections
import scala.collection.immutable.ListMap

@Component
class DashboardAsCodeGenerator @Autowired()(dashboardService: DashboardService) extends GenerateStrategy[Dashboard] {
  override val generateOrder: Double = 50

  override def isDefinedAt(config: CiGenerateConfig): Boolean = {
    config.generateConfig.generateDashboards
  }

  override protected def generateGlobal(config: CiGenerateConfig): Map[Option[Folder], List[Dashboard]] = {
    val dashboards = dashboardService.search(null).map { dashboard =>
      processDashboard(dashboard, title = dashboard.getTitle, removeRoles = false)
    }

    ListMap(None -> dashboards.toList)
  }

  override protected def generateFolder(config: CiGenerateConfig): Map[Option[Folder], List[Dashboard]] = {
    val dashboards = config.folders.map { folder =>
      Some(folder) -> dashboardService.search(folder.getId, null, enforcePermissionsOnGenerate(config, folder.getId)).map { dashboard =>
        processDashboard(dashboard, title = dashboard.getTitle)
      }.toList
    }

    ListMap(dashboards: _*)
  }

  private def processDashboard(dashboard: Dashboard, title: String = null, removeRoles: Boolean = true): Dashboard = {
    dashboard.setParentId(null)
    dashboard.setTitle(title)
    if (removeRoles) {
      dashboard.setRoleEditors(Collections.emptyList[String])
      dashboard.setRoleViewers(Collections.emptyList[String])
    }

    dashboard
  }
}
