package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.xlrelease.api.v1.filter.EnvironmentLabelFilters
import com.xebialabs.xlrelease.environments.service.EnvironmentLabelService
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.udm.reporting.filters.EnvironmentLabelFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Autowired
class EnvironmentLabelFilterStringReferenceCreationHandler(environmentLabelService: EnvironmentLabelService) extends StringReferenceCreationHandler {
  override def isDefinedAt(config: StringReferenceCreationConfig): Boolean = config.ci.isInstanceOf[EnvironmentLabelFilter]

  override def apply(config: StringReferenceCreationConfig): StringReferenceContainer = {
    val filter = config.ci.asInstanceOf[EnvironmentLabelFilter]
    val labelName = filter.getEnvironmentLabelId
    val searchFilter = new EnvironmentLabelFilters
    val descriptor = filter.getType.getDescriptor.getPropertyDescriptor("environmentLabelId")

    searchFilter.setTitle(labelName)

    val results = environmentLabelService.searchLabels(searchFilter)
    val value = results.asScala
      .map(env => Ids.getName(env.getId))
      .headOption
      .getOrElse(throw new AsCodeException(s"Label with name $labelName was not found. Please create it first before using it."))
    config.ci.setId("-1")

    StringReferenceContainer(config.ci, Map(descriptor -> Some(value)))
  }
}
