package com.xebialabs.xlrelease.ascode.yaml.model

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{Metadata, Property}
import com.xebialabs.xlrelease.domain.notification.MailPriority
import com.xebialabs.xlrelease.notifications.configuration.EmailNotificationSettings
import com.xebialabs.xlrelease.notifications.configuration.trigger.{NotificationTriggerSettings, RecipientSettings, TemplateSettings}

import java.util
import java.util.Collections.emptySet
import scala.beans.BeanProperty

object EmailNotificationSettingsAsCode {
  def toEmailNotificationSettings(asCode: EmailNotificationSettingsAsCode): EmailNotificationSettings = {
    val settings: EmailNotificationSettings = Type.valueOf(classOf[EmailNotificationSettings]).getDescriptor.newInstance(null);

    asCode.notifications.forEach { s =>
      val nts = new NotificationTriggerSettings
      nts.setNotificationTriggerName(s.notification)
      nts.setPriority(s.priority)
      val templateSettings = new TemplateSettings
      templateSettings.setSubject(s.subject)
      templateSettings.setBody(s.body)
      nts.setTemplateSettings(templateSettings)
      val bulkTemplateSettings = new TemplateSettings
      bulkTemplateSettings.setSubject(s.bulkSubject)
      bulkTemplateSettings.setBody(s.bulkBody)
      nts.setBulkTemplateSettings(bulkTemplateSettings)
      val recipientSettings = new RecipientSettings
      recipientSettings.setRoles(new util.ArrayList[String](s.roles))
      recipientSettings.setGlobalRoles(new util.ArrayList[String](s.globalRoles))
      recipientSettings.setUsers(new util.ArrayList[String](s.users))
      nts.setRecipientSettings(recipientSettings)

      settings.setNotificationTriggerSettings(nts)
    }

    settings
  }
}

// temp hack for CI serialization
@Metadata(root = CONFIGURATION, versioned = false)
class EmailNotificationSettingsAsCode extends BaseConfigurationItem {
  @Property(asContainment = true)
  @BeanProperty
  var notifications: java.util.List[NotificationTriggerSettingsAsCode] = _
}

@Metadata(root = CONFIGURATION, versioned = false)
class NotificationTriggerSettingsAsCode extends BaseConfigurationItem {
  @Property
  @BeanProperty
  var notification: String = _
  @Property
  @BeanProperty
  var priority: MailPriority = _
  @Property
  @BeanProperty
  var subject: String = _
  @Property
  @BeanProperty
  var body: String = _
  @Property
  @BeanProperty
  var bulkSubject: String = _
  @Property
  @BeanProperty
  var bulkBody: String = _
  @Property
  @BeanProperty
  var roles: java.util.Set[String] = emptySet()
  @Property
  @BeanProperty
  var globalRoles: java.util.Set[String] = emptySet()
  @Property
  @BeanProperty
  var users: java.util.Set[String] = emptySet()
}
