package com.xebialabs.xlrelease.ascode.service.referencehandler.generate

import com.xebialabs.xlrelease.api.v1.ApplicationApi
import com.xebialabs.xlrelease.udm.reporting.filters.ApplicationFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

@Component
@Autowired
class ApplicationFilterGeneratorHandler(applicationApi: ApplicationApi) extends CiReferenceGeneratorHandler {
  override def isDefinedAt(ciWithHome: CiWithHome): Boolean = ciWithHome.ci.isInstanceOf[ApplicationFilter]

  override def apply(ciWithHome: CiWithHome): Unit = {
    val ci = ciWithHome.ci
    val filter = ci.asInstanceOf[ApplicationFilter]

    if (filter.getApplicationId != null) {
      val app = applicationApi.getById(filter.getApplicationId)
      filter.setApplicationId(app.getTitle)
    }
  }
}
