package com.xebialabs.xlrelease.versioning.ascode.form

import com.xebialabs.xlrelease.versioning.ascode._

import java.util
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._

class ValidationReport {
  @BeanProperty
  var warnings: java.util.List[ValidationReportMessage] = new util.ArrayList[ValidationReportMessage]()

  @BeanProperty
  var errors: java.util.List[ValidationReportMessage] = new util.ArrayList[ValidationReportMessage]()
}

class ValidationReportMessage {
  // todo use ciinfo object
  @BeanProperty
  var id: String = _

  @BeanProperty
  var ciType: String = _

  @BeanProperty
  var ciTypeDisplayName: String = _

  @BeanProperty
  var title: String = _

  @BeanProperty
  var folder: String = _

  @BeanProperty
  var folderId: String = _

  @BeanProperty
  var property: String = _

  @BeanProperty
  var message: String = _

  @BeanProperty
  var messageType: String = _

  @BeanProperty
  var messageId: Integer = 0

  @BeanProperty
  var resolvedStatus: Boolean = false
}

class ExternalDependencyReportMessage extends ValidationReportMessage {
  @BeanProperty
  var dependency: CiInfo = _
}

object ValidationReport {
  def messagesToReport(messages: Seq[ValidationMessage]): ValidationReport = {
    val report = new ValidationReport
    report.warnings.addAll(filterAndConvert(ValidationMessage.LEVEL_WARN, messages))
    report.errors.addAll(filterAndConvert(ValidationMessage.LEVEL_ERROR, messages))
    report
  }

  def createWarningReport(messages: Seq[ValidationReportMessage]): ValidationReport = {
    val report = new ValidationReport
    report.warnings.addAll(messages.asJava)
    report
  }

  private def filterAndConvert(level: String, messages: Seq[ValidationMessage]): java.util.List[ExternalDependencyReportMessage] = {
    messages
      .filter(_.messageLevel == level)
      .map(ValidationReportMessage.validationMessageToReportMessage)
      .asJava
  }
}

object ValidationReportMessage {
  def validationMessageToReportMessage(msg: ValidationMessage): ExternalDependencyReportMessage = {
    val report = msg match {
      case _: HardcodedPassword => new ExternalDependencyReportMessage
      case _: MissingPassword => new ExternalDependencyReportMessage
      case NonVersionedRef(_, _, ref) =>
        val m = new ExternalDependencyReportMessage
        if (ref != null) {
          m.setDependency(ref)
        }
        m
    }
    report.messageType = msg.messageType
    report.message = msg.message
    report.id = msg.ci.id
    report.folder = msg.ci.folderPath
    report.folderId = msg.ci.folderId
    report.title = msg.ci.title
    report.ciType = msg.ci.ciType
    report.ciTypeDisplayName = msg.ci.ciTypeDisplayName
    report.property = msg.property
    if (report.dependency == null) {
      report.dependency = new CiInfo(msg.ci.id,
        msg.ci.ciType,
        msg.ci.ciTypeDisplayName,
        msg.ci.folderPath,
        msg.ci.folderId,
        msg.ci.title)
    }
    report
  }
}
