package com.xebialabs.xlrelease.ascode.yaml.parser

import com.fasterxml.jackson.databind.JsonNode
import com.xebialabs.ascode.yaml.model.permission.PermissionRelation
import com.xebialabs.ascode.yaml.parser.PermissionSpecParser
import com.xebialabs.xlrelease.ascode.yaml.model.permission.{TaskAccessRelation, TeamPermissionRelation}

object XLRPermissionSpecParser {
  private def parseTaskAccessPermissions(node: JsonNode): TaskAccessRelation = {
    TaskAccessRelation.parse(node)
  }

  private def parseTeamPermissions(folder: JsonNode): TeamPermissionRelation = {
    TeamPermissionRelation.parse(folder)
  }

  def parse(node: JsonNode): PermissionRelation = {
    if (node.has("taskAccess")) {
      parseTaskAccessPermissions(node.get("taskAccess"))
    } else {
      parseTeamPermissions(node)
    }
  }

  def apply() = new PermissionSpecParser(parse)
}
