package com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler

import com.xebialabs.ascode.utils.TypeSugar._
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor
import com.xebialabs.xlrelease.ascode.service.FolderAsCodeService
import com.xebialabs.xlrelease.ascode.service.referencehandler.stringhandler.CreateReleaseTaskStringReferenceCreationHandler._
import com.xebialabs.xlrelease.domain.CreateReleaseTask
import com.xebialabs.xlrelease.service.ReleaseService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

object CreateReleaseTaskStringReferenceCreationHandler {
  val folderIdField = "folderId"
  val templateIdField = "templateId"

  def templateIdDescriptor: PropertyDescriptor = typeOf[CreateReleaseTask].getDescriptor.getPropertyDescriptor(templateIdField)

  def folderIdDescriptor: PropertyDescriptor = typeOf[CreateReleaseTask].getDescriptor.getPropertyDescriptor(folderIdField)

  val properties: Set[String] = Set(
    folderIdField,
    templateIdField
  )
}

@Component
class CreateReleaseTaskStringReferenceCreationHandler @Autowired()(releaseService: ReleaseService, folderAsCodeService: FolderAsCodeService)
  extends StringReferenceCreationHandler {

  override def isDefinedAt(config: StringReferenceCreationConfig): Boolean = {
    config.ci.isInstanceOf[CreateReleaseTask] &&
      (templateIdDescriptor.get(config.ci) != null || folderIdDescriptor.get(config.ci) != null)
  }

  // scalastyle:off cyclomatic.complexity
  override def apply(config: StringReferenceCreationConfig): StringReferenceContainer = {
    val templateId = TemplateStringReferenceCreationUtil.mapWorkflowIdToProp(
      config, templateIdDescriptor, templateIdDescriptor.get(config.ci), folderAsCodeService, releaseService)
    val folderId = TemplateStringReferenceCreationUtil.mapFolderIdToProp(config, folderIdDescriptor, folderAsCodeService)
    StringReferenceContainer(config.ci, (templateId ++ folderId).toMap)
  }
}
