package com.xebialabs.xlrelease.ascode.yaml.parser

import com.fasterxml.jackson.databind.{JsonNode, ObjectMapper}
import com.xebialabs.ascode.yaml.model.Spec
import com.xebialabs.ascode.yaml.parser.SpecParser
import com.xebialabs.ascode.yaml.parser.util.JsonNodeSugar._
import com.xebialabs.xlrelease.ascode.yaml.model.{Application, ApplicationsSpec}

import scala.jdk.CollectionConverters._

object ApplicationsSpecParser extends SpecParser {
  private def parseApplication(node: JsonNode): Application = {
    val name = node.requiredString("name")
    val environments = node.listOfStrings("environments")
    Application(name, environments)
  }

  override def parse(definitionKind: String, metadata: Option[Map[String, String]], node: JsonNode)
                    (implicit mapper: ObjectMapper): Spec = {
    ApplicationsSpec(node.elements().asScala.map(parseApplication).toList)
  }
}
