package com.xebialabs.xlrelease.ascode.service

import com.xebialabs.ascode.service.spec.InterpreterContext
import com.xebialabs.ascode.yaml.dto.AsCodeResponse
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData
import com.xebialabs.xlrelease.ascode.yaml.parser.XLRDefinitionParser
import grizzled.slf4j.Logging
import org.springframework.stereotype.Service

import java.io._
import scala.util.Using

object ArchiveProcessor {
  val INDEX_FILE = "index.yaml"
}

@Service
class ArchiveProcessor(definitionInterpreterService: DefinitionInterpreterService,
                       parser: XLRDefinitionParser
                      ) extends Logging {

  import ArchiveProcessor.INDEX_FILE

  def process(in: InputStream, scmData: SCMTraceabilityData): AsCodeResponse = {
    Using.Manager { use =>
      val mapper = use(new TempFileResolver(in))
      val definition = mapper.resolve(INDEX_FILE) match {
        case Some(indexFile) =>
          val stream = use(indexFile.getInputStream)
          val definition = parser.parse(stream)
          logger.debug(s"Read CI Spec from archive: ${definition.spec}")
          ArtifactResolver(mapper).resolveArtifacts(definition)
          definition
        case None =>
          throw new FileNotFoundException(s"The applied archive does not contain an `$INDEX_FILE`")
      }
      // interpret must be invoked with mapper still open so it can resolve artifact files
      val context = InterpreterContext(definition, Option(scmData))
      definitionInterpreterService.interpret(context)
    }.get
  }
}
