package com.xebialabs.xlrelease.ascode.service.previewhandler

import com.xebialabs.ascode.yaml.dto.PreviewResponse
import com.xebialabs.ascode.yaml.model.Definition
import com.xebialabs.xlrelease.ascode.service.MetadataProcessor
import com.xebialabs.xlrelease.ascode.service.validator.SpecValidator
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util.{List => JavaList}
import scala.jdk.CollectionConverters._

@Service
@Autowired
class PreviewService(handlers: JavaList[PreviewHandler],
                     specValidators: JavaList[SpecValidator],
                     metadataProcessor: MetadataProcessor) {
  private val preview = PreviewHandler.compose(handlers.asScala)
  private val validate = SpecValidator.compose(specValidators.asScala)

  def preview(definition: Definition): PreviewResponse = {
    validate(definition)
    val metadata: Map[String, String] = metadataProcessor.processMetadata(definition.kind, definition.metadata)
    preview(PreviewConfig(definition.spec, metadata))
  }
}
