package com.xebialabs.xlrelease.ascode.utils

import com.xebialabs.ascode.utils.{Utils => GeneralUtils}
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.ChangedIds
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.EntityKinds._
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem

import scala.collection.immutable.ListMap
import scala.jdk.CollectionConverters._

object ConfigurationItemUtils {
  /**
    * Create or update cis as needed. Return a list of created/updated cis, changedIds and a list of orphaned cis
  */
  def createCis[T <: ConfigurationItem](cis: List[T],
                                        storedCis: List[T],
                                        idExtractor: T => String,
                                        createCi: T => T,
                                        updateCi: (T, T) => T): (List[T], ChangedIds, List[T]) = {
    val storedCisAsMap: ListMap[String, T] = ListMap(storedCis.map(x => idExtractor(x) -> x): _*)
    val cisAsMap: ListMap[String, T] = ListMap(cis.map(x => idExtractor(x) -> x): _*)

    val cisToCreate = GeneralUtils.mapMinusKeys(cisAsMap, storedCisAsMap.keySet)
    val cisOrphaned = GeneralUtils.mapMinusKeys(storedCisAsMap, cisAsMap.keySet).values.toList
    val cisToUpdate = GeneralUtils.pickFromMapByKeys(storedCisAsMap, cisAsMap.keySet)

    val createdCis = cisToCreate.values.map(createCi)
    val createdAndUpdated = cis
      .map(idExtractor)
      .filter(cisToUpdate.asJava.containsKey)
      .flatMap { ciId =>
        storedCisAsMap.get(ciId).map { existingCi =>
          val updatedCi = cisAsMap(ciId)
          updateCi(existingCi, updatedCi)
        }
      } ++ createdCis

    val allUpdatedCis = CI.ids.withCreated(createdCis.map(_.getId).toList)
      .withUpdated(cisToUpdate.values.map(_.getId).toList)

    (createdAndUpdated, allUpdatedCis, cisOrphaned)
  }
}
