/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.ascode.service;

import com.xebialabs.ascode.exception.AsCodeException;
import com.xebialabs.ascode.exception.AsCodeException$;
import com.xebialabs.ascode.yaml.dto.AsCodeResponse;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;
import com.xebialabs.xlrelease.ascode.service.DashboardAsCodeService;
import com.xebialabs.xlrelease.ascode.service.ImportResult;
import com.xebialabs.xlrelease.ascode.service.PostCommitAction;
import com.xebialabs.xlrelease.ascode.service.ReferenceSolver;
import com.xebialabs.xlrelease.ascode.utils.DateUtils$;
import com.xebialabs.xlrelease.ascode.utils.ImportContext;
import com.xebialabs.xlrelease.ascode.utils.ImportContext$;
import com.xebialabs.xlrelease.ascode.utils.ImportScope;
import com.xebialabs.xlrelease.ascode.utils.TemplateScope;
import com.xebialabs.xlrelease.ascode.utils.Utils$;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Link;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.UserInputTask;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.events.CreatedFromAsCode;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedFromAsCodeEvent;
import com.xebialabs.xlrelease.domain.events.TemplateVariablesChangedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationMessage;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FacetService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.variable.VariableHelper$;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import com.xebialabs.xlrelease.versioning.ascode.ImportValidator;
import com.xebialabs.xltype.serialization.CiReference;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\t-h\u0001\u0002\u000f\u001e\u0001!B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011a\u0003!\u0011!Q\u0001\neC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\u0006A\u0002!\t!\u0019\u0005\u0006u\u0002!\ta\u001f\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\t\t\b\u0001C\u0005\u0003gBq!! \u0001\t\u0013\ty\bC\u0004\u0002\f\u0002!I!!$\t\u000f\u0005]\u0005\u0001\"\u0003\u0002\u001a\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBAb\u0001\u0011%\u0011Q\u0019\u0005\b\u0003?\u0004A\u0011BAq\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/AqAa\b\u0001\t\u0013\u0011\t\u0003C\u0004\u0003<\u0001!IA!\u0010\t\u000f\tm\u0003\u0001\"\u0003\u0003^!9!\u0011\u0011\u0001\u0005\n\t\r\u0005b\u0002BG\u0001\u0011%!q\u0012\u0005\b\u00057\u0003A\u0011\u0002BO\u0011\u001d\u00119\u000b\u0001C\u0005\u0005SCqA!0\u0001\t\u0013\u0011yLA\u000bUK6\u0004H.\u0019;f\u0003N\u001cu\u000eZ3TKJ4\u0018nY3\u000b\u0005yy\u0012aB:feZL7-\u001a\u0006\u0003A\u0005\na!Y:d_\u0012,'B\u0001\u0012$\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002%K\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002M\u0005\u00191m\\7\u0004\u0001M\u0019\u0001!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g!\t\u0001T'D\u00012\u0015\t\u00114'A\u0003tY\u001a$$NC\u00015\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u001c2\u0005\u001daunZ4j]\u001e\faB]3mK\u0006\u001cXmU3sm&\u001cW\r\u0005\u0002:w5\t!H\u0003\u0002\u001fC%\u0011AH\u000f\u0002\u000f%\u0016dW-Y:f'\u0016\u0014h/[2f\u0003Y!\u0017m\u001d5c_\u0006\u0014H-Q:D_\u0012,7+\u001a:wS\u000e,\u0007CA A\u001b\u0005i\u0012BA!\u001e\u0005Y!\u0015m\u001d5c_\u0006\u0014H-Q:D_\u0012,7+\u001a:wS\u000e,\u0017a\u0004:fM\u0016\u0014XM\\2f'>dg/\u001a:\u0011\u0005}\"\u0015BA#\u001e\u0005=\u0011VMZ3sK:\u001cWmU8mm\u0016\u0014\u0018!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011\u0001jS\u0007\u0002\u0013*\u0011!*I\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001'J\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\fG&LEmU3sm&\u001cW\r\u0005\u0002:\u001f&\u0011\u0001K\u000f\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\u0005fm\u0016tGOQ;t!\t\u0019f+D\u0001U\u0015\t)\u0016%\u0001\u0004fm\u0016tGo]\u0005\u0003/R\u0013\u0011\u0003\u0017'SK2,\u0017m]3Fm\u0016tGOQ;t\u0003e1\u0017mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u0011\u0005!S\u0016BA.J\u0005e1\u0015mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u0002\u0019\u0019\f7-\u001a;TKJ4\u0018nY3\u0011\u0005er\u0016BA0;\u000511\u0015mY3u'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}QI!m\u00193fM\u001eD\u0017N\u001b\t\u0003\u007f\u0001AQaN\u0005A\u0002aBQ!P\u0005A\u0002yBQAQ\u0005A\u0002\rCQAR\u0005A\u0002\u001dCQ!T\u0005A\u00029CQ!U\u0005A\u0002ICQ\u0001W\u0005A\u0002eCQ\u0001X\u0005A\u0002uC#!\u00037\u0011\u00055DX\"\u00018\u000b\u0005=\u0004\u0018AC1o]>$\u0018\r^5p]*\u0011\u0011O]\u0001\bM\u0006\u001cGo\u001c:z\u0015\t\u0019H/A\u0003cK\u0006t7O\u0003\u0002vm\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001x\u0003\ry'oZ\u0005\u0003s:\u0014\u0011\"Q;u_^L'/\u001a3\u0002\u000fA\u0014xnY3tgR!Ap`A\b!\tyT0\u0003\u0002\u007f;\ta\u0011*\u001c9peR\u0014Vm];mi\"9\u0011\u0011\u0001\u0006A\u0002\u0005\r\u0011aB2p]R,\u0007\u0010\u001e\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B\u0010\u0002\u000bU$\u0018\u000e\\:\n\t\u00055\u0011q\u0001\u0002\u000e\u00136\u0004xN\u001d;D_:$X\r\u001f;\t\u000f\u0005E!\u00021\u0001\u0002\u0014\u0005AA/Z7qY\u0006$X\r\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tI\"I\u0001\u0007I>l\u0017-\u001b8\n\t\u0005u\u0011q\u0003\u0002\b%\u0016dW-Y:f\u0003a1\u0017N\u001c3PeB\u0013X\rZ5diR+W\u000e\u001d7bi\u0016LEm\u001d\u000b\u0005\u0003G\t)\u0005\u0005\u0005\u0002&\u0005M\u0012\u0011HA \u001d\u0011\t9#a\f\u0011\u0007\u0005%2&\u0004\u0002\u0002,)\u0019\u0011QF\u0014\u0002\rq\u0012xn\u001c;?\u0013\r\t\tdK\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0012q\u0007\u0002\u0004\u001b\u0006\u0004(bAA\u0019WA!\u0011QEA\u001e\u0013\u0011\ti$a\u000e\u0003\rM#(/\u001b8h!\u001dQ\u0013\u0011IA\u001d\u0003'I1!a\u0011,\u0005\u0019!V\u000f\u001d7fe!9\u0011qI\u0006A\u0002\u0005%\u0013\u0001D1mYR+W\u000e\u001d7bi\u0016\u001c\b\u0003CA&\u0003+\nI&a\u0018\u000e\u0005\u00055#\u0002BA(\u0003#\n\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005M3&\u0001\u0006d_2dWm\u0019;j_:LA!a\u0016\u0002N\t9A*[:u\u001b\u0006\u0004\b\u0003BA\u0003\u00037JA!!\u0018\u0002\b\tY\u0011*\u001c9peR\u001c6m\u001c9f!\u0019\t\t'a\u001b\u0002\u00149!\u00111MA4\u001d\u0011\tI#!\u001a\n\u00031J1!!\u001b,\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001c\u0002p\t!A*[:u\u0015\r\tIgK\u0001\u0015i\u0016l\u0007\u000f\\1uK\u0006\u00137o\u001c7vi\u0016\u0004\u0016\r\u001e5\u0015\r\u0005e\u0012QOA=\u0011\u001d\t9\b\u0004a\u0001\u00033\nQa]2pa\u0016Dq!a\u001f\r\u0001\u0004\tI$A\u0003uSRdW-\u0001\u0003gS:$GCBAA\u0003\u000f\u000bI\tE\u0003+\u0003\u0007\u000b\u0019\"C\u0002\u0002\u0006.\u0012aa\u00149uS>t\u0007bBA\u0001\u001b\u0001\u0007\u00111\u0001\u0005\b\u0003#i\u0001\u0019AA\n\u0003\u0019\u0019'/Z1uKR9A0a$\u0002\u0012\u0006M\u0005bBA\u0001\u001d\u0001\u0007\u00111\u0001\u0005\b\u0003#q\u0001\u0019AA\n\u0011\u001d\t)J\u0004a\u0001\u0003s\t!!\u001b3\u0002\u001bA\u0014xnY3tg\u001a\u000b7-\u001a;t)\u0011\tY*!)\u0011\u0007)\ni*C\u0002\u0002 .\u0012A!\u00168ji\"9\u00111U\bA\u0002\u0005\u0015\u0016A\u00024bG\u0016$8\u000f\u0005\u0004\u0002b\u0005\u001d\u00161V\u0005\u0005\u0003S\u000byGA\u0002TKF\u0004B!!,\u000246\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b9\"A\u0003gC\u000e,G/\u0003\u0003\u00026\u0006=&!\u0002$bG\u0016$\u0018AB;qI\u0006$X\rF\u0004}\u0003w\u000bi,!1\t\u000f\u0005\u0005\u0001\u00031\u0001\u0002\u0004!9\u0011q\u0018\tA\u0002\u0005M\u0011\u0001C3ySN$\u0018N\\4\t\u000f\u0005E\u0001\u00031\u0001\u0002\u0014\u0005Aa/\u00197jI\u0006$X\r\u0006\u0004\u0002H\u0006m\u0017Q\u001c\t\u0007\u0003C\nY'!3\u0011\t\u0005-\u0017q[\u0007\u0003\u0003\u001bTA!a4\u0002R\u0006Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0007\u0001\n\u0019N\u0003\u0003\u0002V\u0006]\u0011A\u0003<feNLwN\\5oO&!\u0011\u0011\\Ag\u0005E1\u0016\r\\5eCRLwN\\'fgN\fw-\u001a\u0005\b\u0003\u0003\t\u0002\u0019AA\u0002\u0011\u001d\t\t\"\u0005a\u0001\u0003'\t!bZ3oKJ\fG/Z%e+\u0011\t\u0019/!<\u0015\r\u0005e\u0012Q\u001dB\t\u0011\u001d\t9O\u0005a\u0001\u0003S\f!aY5\u0011\t\u0005-\u0018Q\u001e\u0007\u0001\t\u001d\tyO\u0005b\u0001\u0003c\u0014\u0011\u0001V\t\u0005\u0003g\fI\u0010E\u0002+\u0003kL1!a>,\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!a?\u0003\u000e5\u0011\u0011Q \u0006\u0005\u0003\u007f\u0014\t!A\u0002vI6TAAa\u0001\u0003\u0006\u0005\u0019\u0011\r]5\u000b\t\t\u001d!\u0011B\u0001\u0007a2,x-\u001b8\u000b\u0007\t-1%\u0001\u0005eKBdw._5u\u0013\u0011\u0011y!!@\u0003#\r{gNZ5hkJ\fG/[8o\u0013R,W\u000eC\u0004\u0003\u0014I\u0001\r!!\u000f\u0002\u0011A\f'/\u001a8u\u0013\u0012\fA\u0003]8qk2\fG/\u001a+f[Bd\u0017\r^3ECR\fG\u0003CAN\u00053\u0011YB!\b\t\u000f\u0005\u00051\u00031\u0001\u0002\u0004!9\u0011\u0011C\nA\u0002\u0005M\u0001bBAK'\u0001\u0007\u0011\u0011H\u0001\u0012a>\u0004X\u000f\\1uKBC\u0017m]3ECR\fG\u0003DAN\u0005G\u0011iCa\f\u00034\te\u0002b\u0002B\u0013)\u0001\u0007!qE\u0001\u0006a\"\f7/\u001a\t\u0005\u0003+\u0011I#\u0003\u0003\u0003,\u0005]!!\u0002)iCN,\u0007bBA\t)\u0001\u0007\u00111\u0003\u0005\b\u0005c!\u0002\u0019AA\u001d\u0003!1w\u000e\u001c3fe&#\u0007b\u0002B\u001b)\u0001\u0007!qG\u0001\u0005Q>lW\rE\u0003+\u0003\u0007\u000bI\u0004C\u0004\u0002\u0002Q\u0001\r!a\u0001\u0002!A|\u0007/\u001e7bi\u0016$\u0016m]6ECR\fGCDAN\u0005\u007f\u0011IEa\u0015\u0003V\t]#\u0011\f\u0005\b\u0005\u0003*\u0002\u0019\u0001B\"\u0003\u0011!\u0018m]6\u0011\t\u0005U!QI\u0005\u0005\u0005\u000f\n9B\u0001\u0003UCN\\\u0007b\u0002B&+\u0001\u0007!QJ\u0001\nG>tG/Y5oKJ\u0004B!!\u0006\u0003P%!!\u0011KA\f\u00055!\u0016m]6D_:$\u0018-\u001b8fe\"9\u0011\u0011C\u000bA\u0002\u0005M\u0001b\u0002B\u0019+\u0001\u0007\u0011\u0011\b\u0005\b\u0005k)\u0002\u0019\u0001B\u001c\u0011\u001d\t\t!\u0006a\u0001\u0003\u0007\tQ\u0003]8qk2\fG/Z+tKJLe\u000e];u)\u0006\u001c8\u000e\u0006\u0004\u0002\u001c\n}#q\r\u0005\b\u0005\u00032\u0002\u0019\u0001B1!\u0011\t)Ba\u0019\n\t\t\u0015\u0014q\u0003\u0002\u000e+N,'/\u00138qkR$\u0016m]6\t\u000f\t%d\u00031\u0001\u0003l\u0005Ia/\u0019:jC\ndWm\u001d\t\u0007\u0005[\u0012\u0019Ha\u001e\u000e\u0005\t=$\u0002\u0002B9\u0003#\nq!\\;uC\ndW-\u0003\u0003\u0003v\t=$A\u0002\"vM\u001a,'\u000f\u0005\u0003\u0003z\tuTB\u0001B>\u0015\u0011\u0011I'a\u0006\n\t\t}$1\u0010\u0002\t-\u0006\u0014\u0018.\u00192mK\u0006A\u0002o\u001c9vY\u0006$XmQ;ti>l7k\u0019:jaR$\u0016m]6\u0015\t\u0005m%Q\u0011\u0005\b\u0005\u0003:\u0002\u0019\u0001BD!\u0011\t)B!#\n\t\t-\u0015q\u0003\u0002\u0011\u0007V\u001cHo\\7TGJL\u0007\u000f\u001e+bg.\f\u0011\u0004]8qk2\fG/Z\"sK\u0006$XMU3mK\u0006\u001cX\rV1tWR1\u00111\u0014BI\u00053CqA!\u0011\u0019\u0001\u0004\u0011\u0019\n\u0005\u0003\u0002\u0016\tU\u0015\u0002\u0002BL\u0003/\u0011\u0011c\u0011:fCR,'+\u001a7fCN,G+Y:l\u0011\u001d\t\t\u0001\u0007a\u0001\u0003\u0007\t\u0001\u0003]8qk2\fG/Z$bi\u0016$\u0016m]6\u0015\t\u0005m%q\u0014\u0005\b\u0005\u0003J\u0002\u0019\u0001BQ!\u0011\t)Ba)\n\t\t\u0015\u0016q\u0003\u0002\t\u000f\u0006$X\rV1tW\u0006\t\u0002o\u001c9vY\u0006$X\rV1tW\u001e\u0013x.\u001e9\u0015\u0019\u0005m%1\u0016B[\u0005o\u0013ILa/\t\u000f\t5&\u00041\u0001\u00030\u0006)qM]8vaB!\u0011Q\u0003BY\u0013\u0011\u0011\u0019,a\u0006\u0003\u0013Q\u000b7o[$s_V\u0004\bbBA\t5\u0001\u0007\u00111\u0003\u0005\b\u0005cQ\u0002\u0019AA\u001d\u0011\u001d\u0011)D\u0007a\u0001\u0005oAq!!\u0001\u001b\u0001\u0004\t\u0019!\u0001\bqe>\u001cWm]:TG6$\u0015\r^1\u0015\r\u0005m%\u0011\u0019Bn\u0011\u001d\u0011\u0019m\u0007a\u0001\u0005\u000b\fA\u0001Z1uCB)!&a!\u0003HB!!\u0011\u001aBl\u001b\t\u0011YM\u0003\u0003\u0003N\n=\u0017a\u00013u_*!!\u0011\u001bBj\u0003\r\u0019wn\u0019\u0006\u0004\u0005+\u001c\u0013A\u0003=ma2\fGOZ8s[&!!\u0011\u001cBf\u0005M\u00196)\u0014+sC\u000e,\u0017MY5mSRLH)\u0019;b\u0011\u001d\t\tb\u0007a\u0001\u0003'A3\u0001\u0001Bp!\u0011\u0011\tOa:\u000e\u0005\t\r(b\u0001Bsi\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\t%(1\u001d\u0002\b'\u0016\u0014h/[2f\u0001")
public class TemplateAsCodeService
implements Logging {
    private final ReleaseService releaseService;
    private final DashboardAsCodeService dashboardAsCodeService;
    private final ReferenceSolver referenceSolver;
    private final ReleaseRepository releaseRepository;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final FacetService facetService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TemplateAsCodeService templateAsCodeService = this;
        synchronized (templateAsCodeService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ImportResult process(ImportContext context, Release template) {
        this.logger().debug((Function0 & Serializable)() -> "Processing template: " + template.toString() + " with metadata " + context.metadata().toString());
        if (!template.getReleaseTriggers().isEmpty()) {
            throw new AsCodeException("Templates with release triggers are no longer supported.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        this.referenceSolver.resolveReferences((ConfigurationItem)template, context.references(), (String)context.scope().getFolderId().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Option<Release> option = this.find(context, template);
        if (option instanceof Some) {
            Some some = (Some)option;
            Release existing = (Release)some.value();
            this.logger().debug((Function0 & Serializable)() -> "Updating template: " + existing.toString());
            return this.update(context, existing, template);
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> "Creating template: " + template.toString());
            String id = (String)context.templateIds().view().mapValues((Function1 & Serializable)x$1 -> (String)x$1._1()).getOrElse((Object)this.templateAbsolutePath(context.scope(), template.getTitle()), (Function0 & Serializable)() -> this.generateId(template, (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> Ids.ROOT_FOLDER_ID)));
            return this.create(context, template, id);
        }
        throw new MatchError(option);
    }

    public scala.collection.immutable.Map<String, Tuple2<String, Release>> findOrPredictTemplateIds(ListMap<ImportScope, List<Release>> allTemplates) {
        return (scala.collection.immutable.Map)allTemplates.toList().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                scala.collection.immutable.Map map = (scala.collection.immutable.Map)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    ImportScope scope = (ImportScope)tuple22._1();
                    List templates = (List)tuple22._2();
                    ImportContext context = new ImportContext(scope, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (List<CiReference>)package$.MODULE$.List().empty(), (Option<SCMTraceabilityData>)None$.MODULE$, ImportContext$.MODULE$.apply$default$5(), ImportContext$.MODULE$.apply$default$6());
                    return (scala.collection.immutable.Map)map.$plus$plus((IterableOnce)templates.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x0$2, x1$2) -> {
                        Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                        if (tuple2 != null) {
                            String string;
                            scala.collection.immutable.Map idMap = (scala.collection.immutable.Map)tuple2._1();
                            Release template = (Release)tuple2._2();
                            Option<Release> option = this.find(context, template);
                            if (None$.MODULE$.equals(option)) {
                                string = this.generateId(template, (String)scope.getFolderId().getOrElse((Function0 & Serializable)() -> Ids.ROOT_FOLDER_ID));
                            } else if (option instanceof Some) {
                                Some some = (Some)option;
                                Release existing = (Release)some.value();
                                string = existing.getId();
                            } else {
                                throw new MatchError(option);
                            }
                            String id = string;
                            return (scala.collection.immutable.Map)idMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.templateAbsolutePath(scope, template.getTitle())), (Object)new Tuple2((Object)id, (Object)template)));
                        }
                        throw new MatchError((Object)tuple2);
                    }));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private String templateAbsolutePath(ImportScope scope, String title) {
        Option<String> option = scope.getFolderPath();
        if (None$.MODULE$.equals(option)) {
            return title;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            return Utils$.MODULE$.joinPaths((Seq<String>)new .colon.colon((Object)path, (List)new .colon.colon((Object)title, (List)Nil$.MODULE$)));
        }
        throw new MatchError(option);
    }

    private Option<Release> find(ImportContext context, Release template) {
        List matches = CollectionConverters$.MODULE$.ListHasAsScala(this.releaseService.findTemplatesByTitle((String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/"), template.getTitle(), 0, 2, 1)).asScala().toList();
        if (matches.length() > 1) {
            this.logger().debug((Function0 & Serializable)() -> "There are multiple templates named [" + template.getTitle() + "] " + context.scope().description() + ", those are: " + matches.toString());
            throw new AsCodeException("Multiple templates are named [" + template.getTitle() + "] " + context.scope().description() + ". Can not determine which one to update.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        return matches.headOption();
    }

    private ImportResult create(ImportContext context, Release template, String id) {
        this.populateTemplateData(context, template, id);
        List<ValidationMessage> messages = this.validate(context, template);
        Release created = this.releaseRepository.create(template, null);
        this.processScmData(context.scmData(), created);
        return new ImportResult((List<AsCodeResponse.ChangedIds>)new .colon.colon((Object)AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withCreated(created.getId()), (List)Nil$.MODULE$), (Seq<PostCommitAction>)new .colon.colon(() -> $this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(created, (ReleaseCreationSource)new CreatedFromAsCode(context.scmData()))), (List)Nil$.MODULE$), (scala.collection.immutable.Map<String, scala.collection.immutable.Map<Type, AsCodeResponse.ChangedIds>>)Predef$.MODULE$.Map().empty(), messages);
    }

    private void processFacets(Seq<Facet> facets) {
        facets.foreach((Function1 & Serializable)facet -> {
            $this.facetService.validate(facet);
            return $this.facetRepositoryDispatcher.create(facet);
        });
    }

    private ImportResult update(ImportContext context, Release existing, Release template) {
        this.populateTemplateData(context, template, existing.getId());
        template.setCiUid(existing.getCiUid());
        List<ValidationMessage> messages = this.validate(context, template);
        Release updated = this.releaseRepository.replace(existing, template);
        this.processScmData(context.scmData(), updated);
        this.processFacets((Seq<Facet>)((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(updated.getAllTasks()).asScala().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TemplateAsCodeService.$anonfun$update$1(x$2)))).flatMap((Function1 & Serializable)x$3 -> CollectionConverters$.MODULE$.ListHasAsScala(x$3.getFacets()).asScala().toSeq())).toSeq());
        java.util.List templateVars = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(updated.getVariables()).asScala().withFilter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.getShowOnReleaseStart())).map((Function1 & Serializable)v -> (Variable)CiCloneHelper.cloneCi((ConfigurationItem)v))).asJava();
        return new ImportResult((List<AsCodeResponse.ChangedIds>)new .colon.colon((Object)AsCodeResponse.EntityKinds$.MODULE$.ExtendedString(AsCodeResponse.EntityKinds$.MODULE$.CI()).ids().withUpdated(updated.getId()), (List)Nil$.MODULE$), (Seq<PostCommitAction>)new .colon.colon(() -> $this.eventBus.publish((XLReleaseEvent)new ReleaseUpdatedFromAsCodeEvent(updated, context.scmData())), (List)new .colon.colon(() -> $this.eventBus.publish((XLReleaseEvent)new TemplateVariablesChangedEvent(updated.getId(), templateVars)), (List)Nil$.MODULE$)), (scala.collection.immutable.Map<String, scala.collection.immutable.Map<Type, AsCodeResponse.ChangedIds>>)Predef$.MODULE$.Map().empty(), messages);
    }

    private List<ValidationMessage> validate(ImportContext context, Release template) {
        Option<ImportValidator> option = context.validator();
        if (option instanceof Some) {
            Some some = (Some)option;
            ImportValidator validator = (ImportValidator)some.value();
            return validator.validateCi((ConfigurationItem)template, context.getFolderInfo()).toList();
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.List().empty();
        }
        throw new MatchError(option);
    }

    private <T extends ConfigurationItem> String generateId(T ci, String parentId) {
        return this.ciIdService.getUniqueId(ci.getType(), parentId);
    }

    public void populateTemplateData(ImportContext context, Release template, String id) {
        Option<String> home = context.scope().getMetadataHome();
        template.setId(id);
        template.setStatus(ReleaseStatus.TEMPLATE);
        if (template.getScheduledStartDate() == null) {
            template.setScheduledStartDate(new Date());
        }
        if (template.getDueDate() == null) {
            if (template.getPlannedDuration() == null) {
                Date nextHour = DateUtils$.MODULE$.addHoursToDate(template.getScheduledStartDate(), 1);
                template.setDueDate(nextHour);
            } else {
                template.setDueDate(new DateTime((Object)template.getScheduledStartDate()).plusSeconds(Predef$.MODULE$.Integer2int(template.getPlannedDuration())).toDate());
            }
        }
        CollectionConverters$.MODULE$.ListHasAsScala(template.getVariables()).asScala().foreach((Function1 & Serializable)variable -> {
            TemplateAsCodeService.$anonfun$populateTemplateData$1(this, template, context, home, variable);
            return BoxedUnit.UNIT;
        });
        this.referenceSolver.resolveStringReference((ConfigurationItem)template, (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/"), home, this.referenceSolver.resolveStringReference$default$4());
        CollectionConverters$.MODULE$.ListHasAsScala(template.getPhases()).asScala().foreach((Function1 & Serializable)phase -> {
            this.populatePhaseData(phase, template, (String)context.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/"), (Option<String>)home, context);
            return BoxedUnit.UNIT;
        });
        ImportContext templateScopedContext = context.copy(new TemplateScope(template.getId(), template.getTitle(), context.scope()), context.copy$default$2(), context.copy$default$3(), context.copy$default$4(), context.copy$default$5(), context.copy$default$6());
        template.getExtensions().forEach(x0$1 -> {
            ReleaseExtension releaseExtension = x0$1;
            if (releaseExtension instanceof Dashboard) {
                Dashboard dashboard = (Dashboard)releaseExtension;
                $this.dashboardAsCodeService.initializeTemplateDashboard(templateScopedContext, dashboard);
                return;
            }
            throw new MatchError((Object)releaseExtension);
        });
    }

    private void populatePhaseData(Phase phase, Release template, String folderId, Option<String> home, ImportContext context) {
        phase.setId(this.generateId(phase, template.getId()));
        phase.setStatus(PhaseStatus.PLANNED);
        phase.setRelease(template);
        CollectionConverters$.MODULE$.ListHasAsScala(phase.getTasks()).asScala().foreach((Function1 & Serializable)task -> {
            this.populateTaskData(task, (TaskContainer)phase, template, folderId, (Option<String>)home, context);
            return BoxedUnit.UNIT;
        });
    }

    private void populateTaskData(Task task, TaskContainer container, Release template, String folderId, Option<String> home, ImportContext context) {
        task.setId(this.generateId(task, container.getId()));
        task.setStatus(TaskStatus.PLANNED);
        task.setContainer(container);
        CollectionConverters$.MODULE$.ListHasAsScala(task.getFacets()).asScala().foreach((Function1 & Serializable)facet -> {
            TemplateAsCodeService.$anonfun$populateTaskData$1(this, task, folderId, home, facet);
            return BoxedUnit.UNIT;
        });
        this.referenceSolver.resolveStringReference((ConfigurationItem)task, folderId, home, (scala.collection.immutable.Map<String, String>)context.templateIds().view().mapValues((Function1 & Serializable)x$5 -> (String)x$5._1()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(task.getRelease(), (VisitableItem)task, this.ciIdService);
        Task task2 = task;
        if (task2 instanceof CustomScriptTask) {
            CustomScriptTask customScriptTask = (CustomScriptTask)task2;
            this.populateCustomScriptTask(customScriptTask);
            return;
        }
        if (task2 instanceof CreateReleaseTask) {
            CreateReleaseTask createReleaseTask = (CreateReleaseTask)task2;
            this.populateCreateReleaseTask(createReleaseTask, context);
            return;
        }
        if (task2 instanceof GateTask) {
            GateTask gateTask = (GateTask)task2;
            this.populateGateTask(gateTask);
            return;
        }
        if (task2 instanceof TaskGroup) {
            TaskGroup taskGroup = (TaskGroup)task2;
            this.populateTaskGroup(taskGroup, template, folderId, home, context);
            return;
        }
        if (task2 instanceof UserInputTask) {
            UserInputTask userInputTask = (UserInputTask)task2;
            this.populateUserInputTask(userInputTask, (Buffer<Variable>)CollectionConverters$.MODULE$.ListHasAsScala(template.getVariables()).asScala());
            return;
        }
    }

    private void populateUserInputTask(UserInputTask task, Buffer<Variable> variables) {
        scala.collection.immutable.Map varMap = ((IterableOnceOps)variables.map((Function1 & Serializable)variable -> new Tuple2((Object)variable.getKey(), variable))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Buffer usedVars = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(task.getVariables()).asScala().filter((Function1 & Serializable)taskVar -> BoxesRunTime.boxToBoolean((boolean)varMap.contains((Object)taskVar.getKey())))).map((Function1 & Serializable)taskVar -> (Variable)varMap.apply((Object)taskVar.getKey()));
        task.setVariables(CollectionConverters$.MODULE$.BufferHasAsJava(usedVars).asJava());
    }

    private void populateCustomScriptTask(CustomScriptTask task) {
        PythonScript pythonScript = task.getPythonScript();
        pythonScript.setId(task.getId() + "/PythonScript");
        pythonScript.setCustomScriptTask(task);
    }

    private void populateCreateReleaseTask(CreateReleaseTask task, ImportContext context) {
        block5: {
            try {
                scala.collection.immutable.Map importingTemplatesById = context.templateIds().view().values().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Option option = Option$.MODULE$.apply((Object)task.getTemplateId()).flatMap((Function1 & Serializable)templateId -> importingTemplatesById.get(templateId).orElse((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> $this.releaseRepository.findById(templateId, ResolveOptions$.MODULE$.WITHOUT_DECORATORS())).toOption()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Release template = (Release)some.value();
                    Map templateVariables = template.getVariablesByKeys();
                    CollectionConverters$.MODULE$.ListHasAsScala(task.getTemplateVariables()).asScala().foreach((Function1 & Serializable)variable -> {
                        TemplateAsCodeService.$anonfun$populateCreateReleaseTask$4(templateVariables, variable);
                        return BoxedUnit.UNIT;
                    });
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    break block5;
                }
                throw new MatchError((Object)option);
            }
            catch (NotFoundException notFoundException) {
                this.logger().warn((Function0 & Serializable)() -> "Unable to process target template for create release task - " + task.getId());
            }
            catch (Exception e) {
                throw e;
            }
        }
        CollectionConverters$.MODULE$.ListHasAsScala(task.getTemplateVariables()).asScala().foreach((Function1 & Serializable)variable -> {
            TemplateAsCodeService.$anonfun$populateCreateReleaseTask$6(this, task, variable);
            return BoxedUnit.UNIT;
        });
    }

    private void populateGateTask(GateTask task) {
        CollectionConverters$.MODULE$.ListHasAsScala(task.getConditions()).asScala().foreach((Function1 & Serializable)condition -> {
            condition.setId(this.ciIdService.getUniqueId(condition.getType(), task.getId()));
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.ListHasAsScala(task.getDependencies()).asScala().foreach((Function1 & Serializable)dep -> {
            TemplateAsCodeService.$anonfun$populateGateTask$2(this, task, dep);
            return BoxedUnit.UNIT;
        });
    }

    private void populateTaskGroup(TaskGroup group, Release template, String folderId, Option<String> home, ImportContext context) {
        CollectionConverters$.MODULE$.ListHasAsScala(group.getTasks()).asScala().foreach((Function1 & Serializable)task -> {
            this.populateTaskData(task, (TaskContainer)group, template, folderId, (Option<String>)home, context);
            return BoxedUnit.UNIT;
        });
        TaskGroup taskGroup = group;
        if (taskGroup instanceof ParallelGroup) {
            ParallelGroup parallelGroup = (ParallelGroup)taskGroup;
            if (!parallelGroup.getLinks().isEmpty()) {
                scala.collection.immutable.Map nameToTask = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(parallelGroup.getTasks()).asScala().map((Function1 & Serializable)task -> new Tuple2((Object)task.getTitle(), task))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                CollectionConverters$.MODULE$.SetHasAsScala(parallelGroup.getLinks()).asScala().foreach((Function1 & Serializable)link -> {
                    TemplateAsCodeService.$anonfun$populateTaskGroup$3(this, group, nameToTask, link);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
    }

    private void processScmData(Option<SCMTraceabilityData> data, Release template) {
        data.filterNot((Function1 & Serializable)scmData -> BoxesRunTime.boxToBoolean((boolean)Utils$.MODULE$.isSCMDataEmpty(scmData))).foreach((Function1 & Serializable)x$7 -> $this.releaseService.createSCMData(template.getId(), x$7));
    }

    public static final /* synthetic */ boolean $anonfun$update$1(Task x$2) {
        return x$2.getFacets().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$populateTemplateData$1(TemplateAsCodeService $this, Release template$3, ImportContext context$6, Option home$1, Variable variable) {
        VariablePersistenceHelper$.MODULE$.fixUpReleaseVariable(variable, template$3.getId(), $this.ciIdService);
        $this.referenceSolver.resolveStringReference((ConfigurationItem)variable, (String)context$6.scope().getFolderId().getOrElse((Function0 & Serializable)() -> "/"), (Option<String>)home$1, $this.referenceSolver.resolveStringReference$default$4());
    }

    public static final /* synthetic */ void $anonfun$populateTaskData$1(TemplateAsCodeService $this, Task task$1, String folderId$2, Option home$3, Facet facet) {
        facet.setTargetId(task$1.getId());
        $this.referenceSolver.resolveStringReference((ConfigurationItem)facet, folderId$2, (Option<String>)home$3, $this.referenceSolver.resolveStringReference$default$4());
    }

    public static final /* synthetic */ void $anonfun$populateCreateReleaseTask$4(Map templateVariables$1, Variable variable) {
        Variable templateVariable = templateVariables$1.getOrDefault(variable.getKey(), variable);
        variable.setValueProvider(templateVariable.getValueProvider());
    }

    public static final /* synthetic */ void $anonfun$populateCreateReleaseTask$6(TemplateAsCodeService $this, CreateReleaseTask task$2, Variable variable) {
        variable.setId($this.generateId(variable, task$2.getId()));
        Option$.MODULE$.apply((Object)variable.getValueProvider()).foreach((Function1 & Serializable)x$6 -> {
            x$6.setId(variable.getId() + "/valueProvider");
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$populateGateTask$2(TemplateAsCodeService $this, GateTask task$3, Dependency dep) {
        if (!VariableHelper$.MODULE$.containsVariables(dep.getTargetId())) {
            throw new AsCodeException("Gate tasks with hardcoded release dependencies cannot be applied, change the dependency to using a variable instead.", AsCodeException$.MODULE$.$lessinit$greater$default$2());
        }
        dep.setId($this.ciIdService.getUniqueId(dep.getType(), task$3.getId()));
    }

    public static final /* synthetic */ void $anonfun$populateTaskGroup$3(TemplateAsCodeService $this, TaskGroup group$1, scala.collection.immutable.Map nameToTask$1, Link link) {
        link.setId($this.generateId(link, group$1.getId()));
        link.setSource((Task)nameToTask$1.apply((Object)link.getSource().getTitle()));
        link.setTarget((Task)nameToTask$1.apply((Object)link.getTarget().getTitle()));
    }

    @Autowired
    public TemplateAsCodeService(ReleaseService releaseService, DashboardAsCodeService dashboardAsCodeService, ReferenceSolver referenceSolver, ReleaseRepository releaseRepository, CiIdService ciIdService, XLReleaseEventBus eventBus, FacetRepositoryDispatcher facetRepositoryDispatcher, FacetService facetService) {
        this.releaseService = releaseService;
        this.dashboardAsCodeService = dashboardAsCodeService;
        this.referenceSolver = referenceSolver;
        this.releaseRepository = releaseRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.facetService = facetService;
        Logging.$init$((Logging)this);
    }
}

