package com.xebialabs.xlrelease.versioning.ascode.form

import com.xebialabs.xlrelease.api.v1.views.VersionInfo
import com.xebialabs.xlrelease.domain.versioning.ascode.validation.ValidationMessage

import java.util
import scala.beans.BeanProperty

class CreateVersionResult extends VersionInfo {
  @BeanProperty
  var errors: java.util.List[CreateVersionError] = new util.ArrayList[CreateVersionError]()
}

object CreateVersionResult {
  def versionInfoToCreateVersionResult(info: VersionInfo): CreateVersionResult = {
    val result = new CreateVersionResult
    result.setName(info.getName)
    result.setAuthor(info.getAuthor)
    result.setCommiter(info.getCommiter)
    result.setCommitHash(info.getCommitHash)
    result.setCommitTime(info.getCommitTime)
    result.setFullMessage(info.getFullMessage)
    result.setShortMessage(info.getShortMessage)
    result
  }
}

class CreateVersionError {
  @BeanProperty
  var id: String = _

  @BeanProperty
  var ciType: String = _

  @BeanProperty
  var title: String = _

  @BeanProperty
  var folder: String = _

  @BeanProperty
  var property: String = _

  @BeanProperty
  var message: String = _
}

object CreateVersionError {
  def validationMessageToError(message: ValidationMessage): CreateVersionError = {
    val error = new CreateVersionError
    error.id = message.getCi.id
    error.ciType = message.getCi.ciTypeDisplayName
    error.title = message.getCi.title
    error.folder = message.getCi.folderPath
    error.property = message.getProperty
    error.message = message.getMessage
    error
  }
}
