package com.xebialabs.xlrelease.ascode.service

import com.xebialabs.ascode.exception.AsCodeException
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.ChangedIds
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.EntityKinds._
import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.xlrelease.api.v1.TenantApi
import com.xebialabs.xlrelease.configuration.TenantLimit
import com.xebialabs.xlrelease.service.TenantService
import grizzled.slf4j.Logging
import org.springframework.stereotype.Service

import scala.util.{Failure, Success, Try}

@Service
class TenantLimitAsCodeService(tenantApi: TenantApi, tenantService: TenantService) extends Logging {
  def createOrUpdateTenantLimit(tenantLimit: TenantLimit): ChangedIds = {
    val tenantId = getTenantId(tenantLimit.getTenantId)
    Try(tenantApi.getLimit(tenantId)) match {
      case Success(_) => tenantApi.updateLimit(tenantId, tenantLimit)
      case Failure(_: NotFoundException) => tenantApi.createLimit(tenantId, tenantLimit)
      case Failure(t) => throw t
    }
    CI.ids.withUpdated(tenantId)
  }

  private def getTenantId(tenantName: String): String = {
    Try(tenantService.findTenantByName(tenantName)) match {
      case Failure(_) =>
        throw new AsCodeException(s"Tenant with name $tenantName was not found. Please create it first before using it.")
      case Success(tenant) =>
        tenant.tenantId
    }
  }
}
