package com.xebialabs.xlrelease.ascode.service

import com.xebialabs.ascode.yaml.dto.AsCodeResponse.ChangedIds
import com.xebialabs.ascode.yaml.dto.AsCodeResponse.EntityKinds.{CI, _}
import com.xebialabs.xlrelease.api.internal.SettingsResource
import com.xebialabs.xlrelease.configuration._
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.notifications.configuration.SmtpServer
import com.xebialabs.xlrelease.versioning.templates.configuration.domain.TemplateVersioningSettings
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service


@Service
class SettingsAsCodeService @Autowired()(settingsResource: SettingsResource) extends Logging {

  def updateSettings(conf: BaseConfiguration): ChangedIds = {
    logger.debug(s"Updating base configuration ${conf.toString}")

    val id = conf match {
      // todo implement generic get id method on these classes
      case _: TemplateVersioningSettings => TemplateVersioningSettings.TEMPLATE_VERSIONING_ID
      case _: ThemeSettings => ThemeSettings.THEME_SETTINGS_ID
      case _: ReportsSettings => ReportsSettings.REPORTS_SETTINGS_ID
      case _: PollingSettings => PollingSettings.POLLING_SETTINGS_ID
      case _: ArchivingSettings => ArchivingSettings.ARCHIVING_SETTINGS_ID
      case _: AuditReportSettings => AuditReportSettings.AUDIT_REPORT_SETTINGS_ID
      case _: SmtpServer => SmtpServer.SMTP_SERVER_ID
      case _: TriggerDataPurgeSettings => TriggerDataPurgeSettings.TRIGGER_DATA_PURGE_SETTINGS_ID
      case _: ExecutionLogPurgeSettings => ExecutionLogPurgeSettings.EXECUTION_LOG_SETTINGS_ID
      case _: ReleasePasswordSettings => ReleasePasswordSettings.PASSWORD_SETTINGS_ID
    }

    val updatedSetting = settingsResource.update(id, conf)
    CI.ids.withUpdated(updatedSetting.getId)
  }
}
