package com.xebialabs.xlrelease.ascode.`export`

import com.xebialabs.ascode.yaml.model.Definition
import com.xebialabs.overthere.local.LocalFile
import com.xebialabs.overthere.util.OverthereUtils
import com.xebialabs.xlrelease.`export`.{TemplateContent, TemplateImportContext, UnzippedTemplateImporter}
import com.xebialabs.xlrelease.ascode.service.{ReferenceSolver, TemplateAsCodeService}
import com.xebialabs.xlrelease.ascode.yaml.parser.XLRDefinitionParser
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.service.CiIdService
import org.springframework.stereotype.Component

import java.nio.charset.StandardCharsets
import java.util
import scala.jdk.CollectionConverters._

case class YamlDefinitionTemplateContent(definition: Definition, localFiles: util.Map[String, LocalFile]) extends TemplateContent

@Component
class YamlUnzippedTemplateImporter(val parser: XLRDefinitionParser,
                                   val ciIdService: CiIdService,
                                   val templateAsCodeService: TemplateAsCodeService,
                                   val referenceSolver: ReferenceSolver)
  extends UnzippedTemplateImporter[YamlDefinitionTemplateContent]
    with YamlTemplateImportHelper {

  override def name(): String = "YAML as-code"

  override def requiredFileName(): String = "index.yaml"

  override def doReadTemplateContent(zipEntries: Map[String, LocalFile], importContext: TemplateImportContext): YamlDefinitionTemplateContent = {
    val content: String = zipEntries.get(requiredFileName()).map(OverthereUtils.read(_, StandardCharsets.UTF_8.name())).orNull
    val definition = parseAndValidate(content)

    YamlDefinitionTemplateContent(definition, zipEntries.asJava)
  }

  override def doUpgradeTemplateContent(templateContent: YamlDefinitionTemplateContent): util.List[String] = {
    // do not upgrade as-code files
    new util.ArrayList[String]()
  }

  override def doConvertToTemplate(templateContent: YamlDefinitionTemplateContent, destinationFolderId: String): Release = {
    convertDefinitionToRelease(templateContent.definition, destinationFolderId)
  }
}
