package com.xebialabs.xlrelease.ascode.service.referencehandler.cireferencehandler

import com.xebialabs.ascode.utils.TypeSugar._
import com.xebialabs.xlrelease.api.v1.RiskApi
import com.xebialabs.xlrelease.risk.domain.RiskProfile
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.core.annotation.Order
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Order(1)
class RiskProfileCiReferenceCreationHandler @Autowired()(riskApi: RiskApi) extends CiReferenceCreationHandler {
  override def isDefinedAt(helper: CiReferenceCreationConfig): Boolean = {
    Option(helper.propertyDescriptor.getReferencedType).exists(_.instanceOf(typeOf[RiskProfile]))
  }

  override def apply(config: CiReferenceCreationConfig): Option[AnyRef] = {
    config.reference.getIds.asScala.headOption.map(riskApi.getRiskProfileByTitle)
  }
}
