package com.xebialabs.xlrelease.ascode.service.referencehandler.cireferencehandler

import com.xebialabs.ascode.utils.TypeSugar._
import com.xebialabs.xlrelease.service.SharedConfigurationService
import com.xebialabs.xlrelease.triggers.event_based.EventBasedTrigger
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.core.annotation.Order
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Order(1)
class EventSourceConfigurationCiReferenceCreationHandler @Autowired()(
                                                            sharedConfigurationService: SharedConfigurationService
                                                          ) extends CiReferenceCreationHandler {
  override def isDefinedAt(helper: CiReferenceCreationConfig): Boolean = {
    helper.ci.isInstanceOf[EventBasedTrigger]
  }

  override def apply(config: CiReferenceCreationConfig): Option[AnyRef] = {
    config.reference.getIds.asScala.flatMap { referencedName =>
      sharedConfigurationService.searchByTypeAndTitle(typeOf("xlrelease.Configuration"), referencedName, config.folderPath, false).asScala.headOption
    }.headOption
  }
}
