package com.xebialabs.xlrelease.ascode.`export`

import com.xebialabs.xlrelease.`export`.{BaseTemplateImporter, ImportType, TemplateImportContext, TemplateImportProcessor}
import com.xebialabs.xlrelease.ascode.service.{ReferenceSolver, TemplateAsCodeService}
import com.xebialabs.xlrelease.ascode.yaml.parser.XLRDefinitionParser
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.service.{CiIdService, ReleaseService, TaskAccessService}
import org.springframework.stereotype.Component

import java.io.InputStream
import java.nio.charset.StandardCharsets
import java.util
import java.util.Optional

@Component
class YamlTemplateImporter(val parser: XLRDefinitionParser,
                           val ciIdService: CiIdService,
                           val templateAsCodeService: TemplateAsCodeService,
                           val referenceSolver: ReferenceSolver,
                           taskAccessService: TaskAccessService,
                           releaseService: ReleaseService,
                           templateProcessors: Optional[util.List[TemplateImportProcessor]],
                           )
  extends BaseTemplateImporter[YamlDefinitionTemplateContent](taskAccessService, releaseService, templateProcessors)
    with YamlTemplateImportHelper {

  override def supports[U <: TemplateImportContext](importContext: U): Boolean = {
    importContext.importType == ImportType.Yaml
  }

  override protected def doReadTemplateContent(inputStream: InputStream, importContext: TemplateImportContext): YamlDefinitionTemplateContent = {
    val definition = parseAndValidate(new String(inputStream.readAllBytes(), StandardCharsets.UTF_8))
    YamlDefinitionTemplateContent(definition, new util.HashMap())
  }

  override protected def doUpgradeTemplateContent(templateContent: YamlDefinitionTemplateContent): util.List[String] = {
    // do not upgrade as-code files
    new util.ArrayList[String]()
  }

  override def doConvertToTemplate(templateContent: YamlDefinitionTemplateContent, destinationFolderId: String): Release = {
    convertDefinitionToRelease(templateContent.definition, destinationFolderId)
  }

}
