/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.analytics.service;

import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.xlrelease.analytics.service.CompFilter;
import com.xebialabs.xlrelease.analytics.service.PlanCalculator;
import com.xebialabs.xlrelease.analytics.service.VariableResolver;
import com.xebialabs.xlrelease.api.v1.ConfigurationApi;
import com.xebialabs.xlrelease.api.v1.FolderApi;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderDirection;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.api.v1.forms.TimeFrame;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.analytics.ProjectedItem;
import com.xebialabs.xlrelease.domain.analytics.ProjectedRelease;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.reports.filters.CompositeFilter;
import com.xebialabs.xlrelease.reports.filters.ReportFilter;
import com.xebialabs.xlrelease.reports.service.ReportsService;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.service.SqlReleasesFilterSupport$;
import com.xebialabs.xlrelease.udm.reporting.AuditReportRequest;
import com.xebialabs.xlrelease.udm.reporting.filters.impl.DateFilter;
import com.xebialabs.xlrelease.udm.reporting.filters.impl.ReleaseStatusFilter;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005\u001dg\u0001B\b\u0011\u0001mA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!A!\b\u0001B\u0001B\u0003%1\b\u0003\u0005C\u0001\t\u0015\r\u0011b\u0001D\u0011!Y\u0006A!A!\u0002\u0013!\u0005\u0002\u0003/\u0001\u0005\u000b\u0007I1A/\t\u0011\u0019\u0004!\u0011!Q\u0001\nyC\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\ta\u0002\u0011\t\u0011)A\u0005c\")A\u000f\u0001C\u0001k\"9\u00111\u0006\u0001\u0005\u0002\u00055\u0002bBA/\u0001\u0011\u0005\u0011q\f\u0005\b\u0003s\u0002A\u0011BA>\u0011\u001d\t9\n\u0001C\u0001\u00033\u0013a\u0002\u00157b]:,'oU3sm&\u001cWM\u0003\u0002\u0012%\u000591/\u001a:wS\u000e,'BA\n\u0015\u0003%\tg.\u00197zi&\u001c7O\u0003\u0002\u0016-\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003/a\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003e\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000f#!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0006g24GG\u001b\u0006\u0002O\u0005AqM]5{u2,G-\u0003\u0002*I\t9Aj\\4hS:<\u0017!\u0005:fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ssB\u0011AfL\u0007\u0002[)\u0011a\u0006F\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u0019.\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\u0013e\u0016dW-Y:f!\u0016\u00148/[:uK:\u001cW\r\u0005\u00024q5\tAG\u0003\u00026m\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\t9T&A\u0002tc2L!!\u000f\u001b\u0003%I+G.Z1tKB+'o]5ti\u0016t7-Z\u0001\u000fe\u0016\u0004xN\u001d;t'\u0016\u0014h/[2f!\ta\u0004)D\u0001>\u0015\t\tbH\u0003\u0002@)\u00059!/\u001a9peR\u001c\u0018BA!>\u00059\u0011V\r]8siN\u001cVM\u001d<jG\u0016\f!b]9m\t&\fG.Z2u+\u0005!\u0005CA#Y\u001d\t1UK\u0004\u0002H':\u0011\u0001*\u0015\b\u0003\u0013Bs!AS(\u000f\u0005-sU\"\u0001'\u000b\u00055S\u0012A\u0002\u001fs_>$h(C\u0001\u001a\u0013\t9\u0002$\u0003\u0002\u0016-%\u0011!\u000bF\u0001\u0003I\nL!a\u000e+\u000b\u0005I#\u0012B\u0001,X\u0003)\u0019\u0016\u000f\u001c\"vS2$WM\u001d\u0006\u0003oQK!!\u0017.\u0003\u000f\u0011K\u0017\r\\3di*\u0011akV\u0001\fgFdG)[1mK\u000e$\b%\u0001\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014X#\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005\r4\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005\u0015\u0004'A\u0005)fe6L7o]5p]\u0016sgm\u001c:dKJ\f1\u0003]3s[&\u001c8/[8o\u000b:4wN]2fe\u0002\n\u0001cY8oM&<WO]1uS>t\u0017\t]5\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017A\u0001<2\u0015\tiG#A\u0002ba&L!a\u001c6\u0003!\r{gNZ5hkJ\fG/[8o\u0003BL\u0017!\u00034pY\u0012,'/\u00119j!\tI'/\u0003\u0002tU\nIai\u001c7eKJ\f\u0005/[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0017YD\u0018P_>\u0002\u001e\u0005}\u0011\u0011\u0005\t\u0003o\u0002i\u0011\u0001\u0005\u0005\u0006U)\u0001\ra\u000b\u0005\u0006c)\u0001\rA\r\u0005\u0006u)\u0001\ra\u000f\u0005\u0006\u0005*\u0001\u001d\u0001\u0012\u0015\u0007wv\f9\"!\u0007\u0011\u0007y\f\u0019\"D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002\u0006\u0005\u001d\u0011a\u00024bGR|'/\u001f\u0006\u0005\u0003\u0013\tY!A\u0003cK\u0006t7O\u0003\u0003\u0002\u000e\u0005=\u0011aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005E\u0011aA8sO&\u0019\u0011QC@\u0003\u0013E+\u0018\r\\5gS\u0016\u0014\u0018!\u0002<bYV,\u0017EAA\u000e\u0003]AHN\u001d*fa>\u001c\u0018\u000e^8ssN\u000bH\u000eR5bY\u0016\u001cG\u000fC\u0003]\u0015\u0001\u000fa\fC\u0003h\u0015\u0001\u0007\u0001\u000eC\u0003q\u0015\u0001\u0007\u0011\u000fK\u0002\u000b\u0003K\u00012A`A\u0014\u0013\r\tIc \u0002\n\u0003V$xn^5sK\u0012\f!\u0003\u001d7b]\u0006\u001bG/\u001b<f%\u0016dW-Y:fgR1\u0011qFA(\u00033\u0002b!!\r\u0002<\u0005\u0005c\u0002BA\u001a\u0003oq1aSA\u001b\u0013\u0005y\u0012bAA\u001d=\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001f\u0003\u007f\u00111aU3r\u0015\r\tID\b\t\u0005\u0003\u0007\nY%\u0004\u0002\u0002F)\u00191#a\u0012\u000b\u0007\u0005%C#\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003\u001b\n)E\u0001\tQe>TWm\u0019;fIJ+G.Z1tK\"9\u0011\u0011K\u0006A\u0002\u0005M\u0013\u0001\u00029bO\u0016\u00042!HA+\u0013\r\t9F\b\u0002\u0005\u0019>tw\rC\u0004\u0002\\-\u0001\r!a\u0015\u0002\u00199,XNY3s\u0005f\u0004\u0016mZ3\u0002+Ad\u0017M\\\"p[BdW\r^3e%\u0016dW-Y:fgRA\u0011qFA1\u0003G\n)\u0007C\u0004\u0002R1\u0001\r!a\u0015\t\u000f\u0005mC\u00021\u0001\u0002T!9\u0011q\r\u0007A\u0002\u0005%\u0014a\u00037bgR\u001c\u0005.Z2lK\u0012\u0004B!a\u001b\u0002v5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(\u0001\u0003vi&d'BAA:\u0003\u0011Q\u0017M^1\n\t\u0005]\u0014Q\u000e\u0002\u0005\t\u0006$X-\u0001\u000esK2,\u0017m]3JIN<\u0016\u000e\u001e5EKB,g\u000eZ3oG&,7\u000f\u0006\u0003\u0002~\u0005M\u0005CBA\u0019\u0003\u007f\n\u0019)\u0003\u0003\u0002\u0002\u0006}\"\u0001\u0002'jgR\u0004B!!\"\u0002\u000e:!\u0011qQAE!\tYe$C\u0002\u0002\fz\ta\u0001\u0015:fI\u00164\u0017\u0002BAH\u0003#\u0013aa\u0015;sS:<'bAAF=!9\u0011QS\u0007A\u0002\u0005u\u0014A\u0003:fY\u0016\f7/Z%eg\u0006a\u0001\u000f\\1o%\u0016dW-Y:fgR!\u0011qFAN\u0011\u001d\t)J\u0004a\u0001\u0003;\u0003b!!\r\u0002<\u0005}\u0005\u0003BAQ\u0003gsA!a)\u00020:!\u0011QUAW\u001d\u0011\t9+a+\u000f\u0007!\u000bI+\u0003\u0002/)%\u0011q'L\u0005\u0003kYJ1!!-5\u0003\u0011\u0019\u0015.\u00133\n\t\u0005U\u0016q\u0017\u0002\u0005\u0007&LEMC\u0002\u00022RB3\u0001AA^!\u0011\ti,a1\u000e\u0005\u0005}&\u0002BAa\u0003\u0017\t!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t)-a0\u0003\u000fM+'O^5dK\u0002")
public class PlannerService
implements Logging {
    private final ReleaseRepository releaseRepository;
    private final ReleasePersistence releasePersistence;
    private final ReportsService reportsService;
    private final SqlBuilder.Dialect sqlDialect;
    private final PermissionEnforcer permissionEnforcer;
    private final ConfigurationApi configurationApi;
    private final FolderApi folderApi;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        PlannerService plannerService = this;
        synchronized (plannerService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public Seq<ProjectedRelease> planActiveReleases(long page, long numberByPage) {
        ReleasesFilters filters = new ReleasesFilters();
        filters.setPlanned(true);
        filters.setActive(true);
        filters.setOrderBy(ReleaseOrderMode.start_date);
        filters.setOrderDirection(ReleaseOrderDirection.ASC);
        Tuple2 sqlWithParams = SqlReleasesFilterSupport$.MODULE$.sqlBuilderByFilters(filters, (Iterable)package$.MODULE$.Seq().empty(), (Iterable)package$.MODULE$.Seq().empty(), SqlReleasesFilterSupport$.MODULE$.sqlBuilderByFilters$default$4(), this.permissionEnforcer(), this.sqlDialect()).selectReleaseId().withPage(new Page((long)((int)page), (long)((int)numberByPage), Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4())).build();
        ArrayBuffer releaseIds = this.releasePersistence.findReleaseIdsByQuery(sqlWithParams);
        Seq<ProjectedRelease> plannedReleases = this.planReleases((Seq<String>)releaseIds.toSeq());
        return plannedReleases;
    }

    public Seq<ProjectedRelease> planCompletedReleases(long page, long numberByPage, Date lastChecked) {
        AuditReportRequest request = new AuditReportRequest((Seq)new .colon.colon((Object)new CompFilter(CompositeFilter.Operator.OR, (Seq<ReportFilter>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReportFilter[]{new ReleaseStatusFilter(ReleaseStatus.COMPLETED), new ReleaseStatusFilter(ReleaseStatus.ABORTED)})), (List)new .colon.colon((Object)new DateFilter(TimeFrame.RANGE, lastChecked, null), (List)Nil$.MODULE$)), (Option)new Some((Object)ReleaseOrderMode.start_date));
        List releases = CollectionConverters$.MODULE$.ListHasAsScala(this.reportsService.getReleasesForPreview(request, page, numberByPage)).asScala().toList();
        PlanCalculator calculator = new PlanCalculator(null);
        Map<String, ProjectedItem> computed = calculator.calculateDates((List<Release>)releases);
        return releases.map((Function1 & Serializable)rel -> (ProjectedRelease)computed.apply((Object)rel.getId()));
    }

    private List<String> releaseIdsWithDependencies(List<String> releaseIds) {
        scala.collection.immutable.Set processing = releaseIds.map((Function1 & Serializable)x$1 -> Ids.getName((String)x$1)).toSet();
        scala.collection.immutable.Set releases = Predef$.MODULE$.Set().empty();
        while (!processing.isEmpty()) {
            scala.collection.immutable.Set targets = this.releasePersistence.getDependencies(processing.toList()).map((Function1 & Serializable)x$1 -> x$1.targetReleaseId()).toSet();
            releases = (scala.collection.immutable.Set)releases.$plus$plus((IterableOnce)processing);
            processing = targets.isEmpty() ? Predef$.MODULE$.Set().empty() : (scala.collection.immutable.Set)targets.diff((Set)releases);
        }
        return releases.toList();
    }

    public Seq<ProjectedRelease> planReleases(Seq<String> releaseIds) {
        List<String> relsWithDeps = this.releaseIdsWithDependencies((List<String>)releaseIds.toList());
        PlanCalculator calculator = new PlanCalculator(new VariableResolver(this.configurationApi, this.folderApi));
        Map<String, ProjectedItem> computed = calculator.calculateDates((List<Release>)this.releaseRepository.getReleasesWithoutComments(relsWithDeps));
        return (Seq)releaseIds.map((Function1 & Serializable)id -> (ProjectedRelease)computed.apply(id));
    }

    @Autowired
    public PlannerService(ReleaseRepository releaseRepository, ReleasePersistence releasePersistence, ReportsService reportsService, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect sqlDialect, PermissionEnforcer permissionEnforcer, ConfigurationApi configurationApi, FolderApi folderApi) {
        this.releaseRepository = releaseRepository;
        this.releasePersistence = releasePersistence;
        this.reportsService = reportsService;
        this.sqlDialect = sqlDialect;
        this.permissionEnforcer = permissionEnforcer;
        this.configurationApi = configurationApi;
        this.folderApi = folderApi;
        Logging.$init$((Logging)this);
    }
}

