global configurationApi
global request, response

from intelligence import SupersetServer

server_id = request.query['serverId']
dashboard_uuid = request.query['dashboardUuid']
has_folder_filter = request.query['hasFolderFilter'].lower() in ('true', '1')

server = configurationApi.getConfiguration(server_id)
folder_name = None
if "folderName" in request.query:
    folder_name = request.query['folderName']

superset = SupersetServer(server)

filters = []
if has_folder_filter and folder_name is not None:
    filters.append("{} IN ('{}')".format(server.folderColumnName, folder_name))

response.entity = superset.get_guest_token(dashboard_uuid, filters)
