import { SagaIterator } from 'redux-saga';
import { put } from 'redux-saga/effects';
import { AnalyticsSidebarProvider } from './analytics-sidebar-provider';
import { navigation } from '../../../../../../../../../../core/xlr-ui/app/features/main-navigation/ducks/navigation.reducer';

const { setBackItem, updateBreadcrumbs, setSidebarMenu, setLastBreadcrumb } = navigation.actions;

describe('AnalyticsSidebarProvider', () => {
    const provider = new AnalyticsSidebarProvider();

    describe('isSupported', () => {
        it('should be false for /analytics path', () => {
            expect(provider.isSupported('/analytics')).toBe(false);
        });

        it('should be true for paths inside /analytics', () => {
            expect(provider.isSupported('/analytics/1')).toBe(true);
        });
    });

    describe('provide', () => {
        it('should call proper sagas', () => {
            const generator: SagaIterator = provider.provide('ignored');
            expect(generator.next().value).toStrictEqual(put(setLastBreadcrumb(undefined)));
            expect(generator.next().value).toStrictEqual(
                put(
                    updateBreadcrumbs([
                        {
                            href: '/dashboards',
                            text: 'Dashboards',
                        },
                        {
                            href: '/analytics',
                            text: 'Analytics',
                        },
                    ]),
                ),
            );
            expect(generator.next().value).toStrictEqual(put(setSidebarMenu({ sidebarMenu: [], withFolder: false })));
            expect(generator.next().value).toStrictEqual(
                put(
                    setBackItem({
                        pathSuffix: 'analytics',
                        title: 'Analytics',
                        text: 'Analytics',
                    }),
                ),
            );
            expect(generator.next().done).toBe(true);
        });
    });
});
