import React from 'react';
import { DotButton, DotIcon } from '@digital-ai/dot-components';
import { ActionToolbarPortal } from '../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';

export interface AnalyticsPagePortalProps {
    buttonHref?: string;
}

export const AnalyticsPagePortal = ({ buttonHref }: AnalyticsPagePortalProps) => {
    const handleOnClick = () => {
        window.open(buttonHref, '_blank');
    };

    return (
        <ActionToolbarPortal>
            {buttonHref && (
                <>
                    <DotButton endIcon={<DotIcon iconId="open-new-tab" />} onClick={handleOnClick}>
                        Manage dashboards
                    </DotButton>
                </>
            )}
        </ActionToolbarPortal>
    );
};
