/* istanbul ignore file */

import React, { createContext, ReactNode, useContext } from 'react';

import { useMicrostrategy } from './useMicrostrategy.hook';

const MicrostrategyContext = createContext<ReturnType<typeof useMicrostrategy> | null>(null);

function useMicrostrategyContext() {
    const context = useContext(MicrostrategyContext);
    if (context === undefined) {
        throw new Error('useMicrostrategyContext must be used within a MicrostrategyProvider');
    }

    return context;
}

interface MstrProviderProps {
    children: ReactNode;
}

function MicrostrategyProvider({ children }: MstrProviderProps) {
    return <MicrostrategyContext.Provider value={useMicrostrategy()}>{children}</MicrostrategyContext.Provider>;
}

export { MicrostrategyProvider, useMicrostrategyContext };
